<?php
function ctword($x) 
{
	$x = abs($x);
	$number = array("", "satu", "dua", "tiga", "empat", "lima",
	"enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
	$temp = "";

	if ($x <12) {
	$temp = " ". $number[$x];
	} else if ($x <20) {
	$temp = ctword($x - 10). " belas";
	} else if ($x <100) {
	$temp = ctword($x/10)." puluh". ctword($x % 10);
	} else if ($x <200) {
	$temp = " seratus" . ctword($x - 100);
	} else if ($x <1000) {
	$temp = ctword($x/100) . " ratus" . ctword($x % 100);
	} else if ($x <2000) {
	$temp = " seribu" . ctword($x - 1000);
	} else if ($x <1000000) {
	$temp = ctword($x/1000) . " ribu" . ctword($x % 1000);
	} else if ($x <1000000000) {
	$temp = ctword($x/1000000) . " juta" . ctword($x % 1000000);
	} else if ($x <1000000000000) {
	$temp = ctword($x/1000000000) . " milyar" . ctword(fmod($x,1000000000));
	} else if ($x <1000000000000000) {
	$temp = ctword($x/1000000000000) . " trilyun" . ctword(fmod($x,1000000000000));
	}
	return $temp;
}

function terbilang($x,$style=4,$strcomma=",") 
{
	if($x<0) {
	$result = "minus ". trim(ctword($x));
	} else {
	$arrnum=explode("$strcomma",$x);
	$arrcount=count($arrnum);
	if ($arrcount==1){
	$result = trim(ctword($x));
	}else if ($arrcount>1){
	$result = trim(ctword($arrnum[0])) . " koma " . trim(ctword($arrnum[1]));
	}
	}
	switch ($style) {
	case 1: //1=uppercase  dan
	$result = strtoupper($result);
	break;
	case 2: //2= lowercase
	$result = strtolower($result);
	break;
	case 3: //3= uppercase on first letter for each word
	$result = ucwords($result);
	break;
	default: //4= uppercase on first letter
	$result = ucfirst($result);
	break;
	}
	return $result;
}

class PDF extends FPDF
{
	//Page header
	function Header()
	{
	    //Logo
		//$this->Image('style/logobesar.png',12,10,25);
		//Arial bold 15
		$this->SetFont('courier','',9);
		//Move to the right
		$this->Cell(0,0,'..........................................................................................................',0,1,2);
		
		$this->Cell(0,11,'YAYASAN PESAT BIRRUL WALIDAIN',0,1,1);
		$this->Cell(0,8,'SMP/SMA/SMK PESAT',0,1,1);
		//$this->Cell(0,8,'',0,1,1);
		$this->SetY(12);
		$this->SetX(120);
		$this->Cell(0,8,'Alamat :',0,1,1);
		$this->SetX(120);
		$this->Cell(0,8,'Jln. Poras No.7 Sindang Barang Loji Bogor',0,1,1);
		//$this->SetX(120);
		//$this->Cell(0,8,'Telpon.  (0251) 8627289',0,1,1);
		$this->Cell(0,3,'..........................................................................................................',0,1,2);
		//Title
		$this->SetY(26);
		$this->SetX(95);
		$this->SetFont('courier','',12);
		$this->Cell(0,22,'TANDA TERIMA',0,1,1);
		
		$this->SetY(27);
		$this->SetX(95);
		$this->Cell(0,22,'____________',0,1,1);
		
		//Line break
		$this->Ln(5);
                
	}	
	
	function Footer() {
	
		//Position at 1.5 cm from bottom
		$this->SetY(-50);
		//Arial italic 8
		$this->SetFont('courier','',10);
		//Page number
		$this->SetX(10);
		$this->Cell(0,15,'Jakarta , '.date('d F Y'),0,1);
		$this->SetX(10);
		$this->Cell(0,4,'Yang Menerima,',0,1);
		$this->SetX(10);
		$this->Cell(0,12,'',0,1);
		$this->SetX(10);
		$this->Cell(0,9,'____________________________',0,1);
		$this->SetX(10);
		$this->Cell(0,0,'Tanda Tangan dan Nama Terang',0,1);
		
	}
}
 
	//Instanciation of inherited class
	$pdf=new PDF();
	$pdf->AliasNbPages();
	$pdf->AddPage();
	$pdf->SetFont('courier','',10);

	$pdf->SetY(23);
	$pdf->SetX(25);
	//$faktur=date('dmy',strtotime($vdate)).'-'.$data['nofaktur'];
	//$pdf->Cell(0,45,'No 	: ' .$faktur,0,1,2);
	$pdf->Cell(0,45,'Nomor Faktur ',0,1);
	$pdf->SetX(60);	
	$pdf->Cell(0,-45,'		:		' .$faktur,0,1);
	//$pdf->Cell(0,45,'No : FM2016021500003',0,1,2);	
	$pdf->SetY(50);
	$pdf->SetX(25);
	$pdf->Cell(0,0,'Sudah terima dari  ',0,1,1);
	$pdf->SetX(60);
	$pdf->Cell(0,0,'		:		' .$diserahkan,0,1);
	//$pdf->Cell(0,0,'		:		Ujang',0,1);
	$pdf->SetX(25);
	$pdf->Cell(0,10,'Banyaknya  ',0,1);
	$pdf->SetX(60);
	$pdf->Cell(0,-9,'		:		'.terbilang($total,$style=3,$strcomma=",").' Rupiah',0,1);
	$pdf->SetX(25);
	$pdf->Cell(0,20,'Keterangan  ',0,1);
	$pdf->SetX(60);
	$pdf->Cell(0,-20,'		:		' ,0,1);
	$pdf->SetY(53);
	$pdf->SetX(70);
	
	$pdf->Cell(0,15,(1).'.'.$keterangan.' Besarnya Rp. '.number_format($total,0,',','.'),0,'C');
	$pdf->Ln();
	$pdf->SetX(70);
	
	$pdf->Ln(0);
	$pdf->SetFont('courier','',9);
	$pdf->Cell(0,10,'..........................................................................................................',0,1,2);
	$pdf->SetFont('courier','BI',12);
	$pdf->SetX(25);
	$pdf->Cell(0,8,'',0,1,2);
	$pdf->SetX(140);
	$pdf->Cell(0,0,'JUMLAH ',0,1);
	$pdf->SetX(155);
	$pdf->Cell(0,0,': Rp.'.number_format($total,0,',' ,'.'),0,1);
	//$pdf->Cell(0,0,': Rp. 2.000.000',0,1);
	
	$pdf->SetX(132);
	$pdf->Cell(0,4,'...........................',0,1,2);
	$pdf->Ln(0);
	$pdf->Output();
?>