<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ref_privilage extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('ref_privilage_model', 'ref_privilage');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	public function index()
	{
		
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			
			$create_button = '""';			
			$update_button = '';
			$delete_button = '';		
						
			if ($this->gparam['privilage']->privilage_create == 'Y') {
				$url = "#".$this->gparam['controller']."/form";
				//create button
				$create_button = '[{
						text: \'Create\',
						iconCls: \'icon-add\',
						handler: function () {					
							window.location.href = "'.$url.'";						
						}
					}]';
			}	
			
			if ($this->gparam['privilage']->privilage_update == 'Y') {
				$update_button = "<a class=\"l-btn l-btn-small l-btn-plain\" onclick=\"edit_view('+row.id+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-pencil fa-lg\"></i>\
								  </a>";
			}
			
			$image_button = "<a class=\"l-btn l-btn-small l-btn-plain\" onclick=\"preview_image('+row.id+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Preview\"><i class=\"fa fa-camera-retro fa-lg\"></i>\
								  </a>";	

			
			if ($this->gparam['privilage']->privilage_delete == 'Y') {	
				$delete_button = "<a class=\"l-btn l-btn-small l-btn-plain\" onclick=\"delete_data('+row.id+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Delete\">\
									<i class=\"fa fa-trash-o  fa-lg\"></i>\
								</a>"; 
			}
			
			// pnumber, psize
			$data = array(
					'controller'  			=> $this->gparam['controller'],
					'psize'  				=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  				=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'create' 				=> $create_button,
					'update' 				=> $update_button,
					'delete'				=> $delete_button,
					'image_button'			=> $image_button
			);
			
			$this->load->view('ref_privilage_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
		
	}
	
	function form() {
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			$data['controller'] = $this->gparam['controller'];				
			$data['action'] = base_url()."index.php/".$this->gparam['controller']."/crud";
			$id = $this->uri->segment(3);	
			
			if (!empty($id)) {
				if ($this->gparam['privilage']->privilage_update == 'Y') {				
					//get value for edit
					$edit = $this->ref_privilage->get_value_edit($id);
					
					$data['privilage_desc'] = $edit->privilage_desc;
					$data['privilage_name'] = $edit->privilage_name;
					$data['id'] 			= $id;
					$data['header'] 		= 'Update Reference Privilage';
					$data['submit'] 		= 'update';	
				} else {
					echo $this->gparam['restrict']; die();
				}	
			} else {
				if ($this->gparam['privilage']->privilage_create == 'Y') {		
					$data['header'] = 'Add Reference Privilage';
					$data['submit'] = 'create';
				} else {
					echo $this->gparam['restrict']; die();
				}	
			}
			
			$this->load->view('crud_ref_privilage',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	public function crud() {
		
		$crud = $this->input->post('submit');
		if ($crud == 'create') {
			
			$insert = $this->ref_privilage->insert_data();
			if ($insert) {
				$json = true;
			}
			
		} else if ($crud == 'update') {
			$update = $this->ref_privilage->update_data();
			if ($update) {
				$json = true;			
			}
				
		}
		
		echo json_encode($json);
		
	}
	
	function cek_privilage_name() {
		
		$id = "";
		$priv_name = $this->input->post('privilage_name');
		$id 	   = $this->input->post('id');
		$cek = $this->ref_privilage->cek_priv_name($priv_name,$id);
		
		if ($cek > 0) {
			$json = false;
		} else {
			$json = true;
		}
		
		echo json_encode($json);
	}
	
	function load_data() {
		header('Content-Type: application/jsonp');
        $list = $this->ref_privilage->get_list_data();
		
        echo json_encode($list);
	}
	
	
}
