<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rep_balance_bln extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('rep_balance_model_bln', 'rep');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	
	public function index()	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
		
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			$act = base_url()."index.php/".$this->gparam['controller']."/load_data";
			
			$excell_download = '<a class="btn btn-success" id="save_excell" href="#" >
								<i class="fa fa-lg fa-fw fa-download"></i>Excell
							  </a>';		

			
			
			// pnumber, psize
			$data = array(
					'controller'  	=> $this->gparam['controller'],
					/* 'psize'			=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  		=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					 */
					 'excell' 		=> $excell_download,
					'action'		=> $act
			);
			
			$this->load->view('rep_balance_view_bln',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	
	function load_data() {
	
		/* $periode = $this->input->post("periode");
		$until = $this->input->post("until");
	    $get_id_siswa = $this->rep_sis->get_id_siswa($peride,$until);
		 */
		
		$periode = $this->input->post("periode");	
		$get_data = $this->rep->get_data($periode);
		$date = new DateTime($periode);
		$resultM = $date->format('M');
		$resultY = $date->format('Y');
		
		/*Header*/
		$html = '<table class="table table-bordered" id="activity_table"><thead>';
		$html .='<tr ><td colspan="5"><center><b>PESAT</b></center></td></tr>';
		$html .='<tr ><td colspan="5"><center><b>Report Balance Bulanan  (Bulan: '.$resultM.', Tahun: '.$resultY.')</b></center></td></tr>';
		$html .='<tr ><td colspan="5"></td></tr>';
		
		$html .='<tr><th style="text-align:center;">No</th>';
		$html .='<th style="text-align:center;">Periode</th>';	
		$html .='<th style="text-align:center;">Tanggal Transaksi</th>';		
		$html .='<th style="text-align:center;">Debit (Db)</th>';
		$html .='<th style="text-align:center;">Credit (Cr)</th>';		
		
		$html .= '</tr></thead>';
		$html .= '<tbody>';
		$i = 1;
		$totaldb = 0;
		$totalcr = 0;
		$balance_total = 0;
		foreach ($get_data as $v_data) {
			
			$html .='<tr>';
			$html .='<td>'.$i.'</td>';
			$html .='<td>'.$resultM.'-'.$resultY.'</td>';
			$html .='<td>'.$v_data['tanggaltransaksi'].'</td>';
			if($v_data['jenis_trans']=='FM'){
				$totaldb = $totaldb + $v_data['total'];
				$html .='<td style="text-align:center;">Rp. '.number_format($v_data['total'],2,",",".").'</td>';	
			}else{
				$html .='<td style="text-align:center;">-</td>';	
			}
			
			if($v_data['jenis_trans']=='FM'){
				$html .='<td style="text-align:center;">-</td>';	
			}else{
				$totalcr = $totalcr + $v_data['total'];
				$html .='<td style="text-align:center;">Rp. '.number_format($v_data['total'],2,",",".").'</td>';		
			}
				
				
			$html .='</tr>';
			$i++;
		}
		$html .='<tr>
			<td colspan="3" style="text-align:center; padding-right:100px; font-size:15px; font-weight: bold;">JUMLAH</td>
			<td style="text-align:center;">Rp. '.number_format($totaldb,2,",",".").'</td>
			<td style="text-align:center;">Rp. '.number_format($totalcr,2,",",".").'</td>
		</tr>';
		$balance_total =  $totaldb - $totalcr;
		$html .='<tr>
			<td colspan="3" style="text-align:center; padding-right:100px; font-size:20px; font-weight: bold;">BALANCE</td>';
			if($balance_total<0){
				$balance_total=$balance_total*(-1);
				$html .='<td colspan="3" style="text-align:center; font-weight: bold; font-size:20px;"> -(Rp. '.number_format($balance_total,2,",",".").')</td>
		</tr>';
			}else{
		$html .='<td colspan="2" style="text-align:center; font-weight: bold; font-size:20px;">Rp. '.number_format($balance_total,2,",",".").'</td>
		</tr>';
			}
		
		$html .= '</tbody>';
		$html .= '</table>';
		$html .= '<script>
					var name = "report_balance_bulanan_'.$resultM.'-'.$resultY.'.xls";
					$("#save_excell").on("click", function () {
						var uri = $("#activity_table").btechco_excelexport({
						containerid: "activity_table"
						, datatype: $datatype.Table
						, returnUri: true
						});
				$(this).attr("download", name).attr("href", uri).attr("target", "_blank");
			});
		</script>';
		echo $html;
	}
	
	
}
