<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rep_tunggakan_ppdb extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('rep_tunggakan_ppdb_model', 'rep_sis');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	
	public function index()	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
		
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			$act = base_url()."index.php/".$this->gparam['controller']."/load_data";
			
			$excell_download = '<a class="btn btn-success" id="save_excell" href="#" >
								<i class="fa fa-lg fa-fw fa-download"></i>Excell
							  </a>';		

			
			$get_smk = $this->rep_sis->getDataSMK();
			$nama_smk='	<select name="smk" class="chosen-select" style="width:195px;" onchange="getJurusan(this.value);cekKelas();getRuang();" >
									<option value="">--Semua Sekolah--</option>';
					
			foreach ($get_smk as $v_smk) {
				$nama_smk .='<option value="'.$v_smk['id'].'">'.$v_smk['name'].'</option>';
			}
			$nama_smk .='</select> ';
			
			$mappingJur = '<div id="id-MappingJur">
					<label class="select">
						<select name="id_mapping_jur" class="chosen-select" style="width:195px;" id="id_mapping_jur" onchange="cekKelas();getRuang();">
							<option value="">--Semua Jurusan--</option>																
						</select> <i></i> 
					</label></div>';
					$kelas='<div id="id-MappingKls"><label class="select">
									<select name="kelas" style="width:195px;" class="chosen-select" onchange="getRuang(this.value);" >
									<option value="">--Semua Kelas--</option></select> <i></i> 
								</label></div>';
								
			$ruang='<div id="id-MappingRuang"><label class="select">
									<select name="ruang" style="width:195px;" class="chosen-select">
									<option value="">--Semua Ruang Kelas--</option></select> <i></i> 
								</label></div>';
			
			
			// pnumber, psize
			$data = array(
					'controller'  	=> $this->gparam['controller'],
					'psize'			=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  		=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'excell' 		=> $excell_download,
					'nama_smk' 		=> $nama_smk,
					'ruang'			=> $ruang,
					'mappingJur'	=> $mappingJur,
					'kelas'			=> $kelas,
					'action'		=> $act
			);
			
			$this->load->view('rep_tunggakan_ppdb_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	
	function load_data() {
	
		/* $periode = $this->input->post("periode");
		$until = $this->input->post("until");
	    $get_id_siswa = $this->rep_sis->get_id_siswa($peride,$until);
		 */
		$bulan = array("July","August","September","October","November","December","January","February","March","April","May","June");
		$now = new \DateTime('now');
	   	$month = $now->format('m');
	   	$year = $now->format('Y');
		
		$curr_bulan = $month - 6;
		if($curr_bulan <= 0){
			$curr_bulan = $month + 6;
		}
			
		$smk = $this->input->post("smk");
		$jur = $this->input->post("id_mapping_jur");
		if((empty($smk))||($smk=='')){
			$get_id_siswa = $this->rep_sis->get_id_siswa('', '');
		}else if((empty($jur))||($jur=='')){
			$get_id_siswa = $this->rep_sis->get_id_siswa($smk, '');
		}else{
			$get_id_siswa = $this->rep_sis->get_id_siswa($smk, $jur);
		}
		
		/*Header*/
		$html = '<table class="table table-bordered" border="1" id="activity_table"><thead><tr>';
		$html .='<th  style="text-align:center;">Nama</th>';
		$html .='<th style="text-align:center;">Sekolah</th>';
		$html .='<th style="text-align:center;">Jurusan</th>';
		$html .='<th style="text-align:center;">Nama Cicilan</th>';
		$html .='<th style="text-align:center;">Tunggakan Cicilan</th>';
		$html .= '</tr></thead>';		
		$html .= '<tbody>';
		/*Close Header*/
		
		$total_all = 0;
		foreach ($get_id_siswa as $v_siswa) {
			/*Get Detail Siswa*/
			$ppdb = $this->rep_sis->get_total_ppdb($v_siswa['id_daftar']);	
			$total_cicilan = $v_siswa['total_cicilan'];
			if(($ppdb=='')||empty($ppdb)){
				$ppdb=0;
			}else{
				$ppdb=$ppdb;
			}
			$jml=$total_cicilan-$ppdb;
			if($jml<=0){
				$jml=0;
			}else{
				$jml=$jml;
			}
			
			$jum_sc = $this->rep_sis->get_count_cicilan_siswa($v_siswa['id_daftar']);
			
			$nama_smk=$this->rep_sis->getSMK($v_siswa['id_smk']);
			$nama_jur=$this->rep_sis->getJrs($v_siswa['id_jur']);
			$html .='<tr><td rowspan="'.$jum_sc.'">'.$this->rep_sis->get_detail($v_siswa['id_daftar']).'</td>';	
			$html .='<td rowspan="'.$jum_sc.'">'.$nama_smk->name.'</td>';
			$html .='<td rowspan="'.$jum_sc.'">'.$nama_jur->nama_jurusan.'</td>';
			
			$cisis = $this->rep_sis->get_cicilan_siswa($v_siswa['id_daftar']);
			
			//$html .='<td rowspan="'.$jum_span.'">'.$jml.'</td>';
			
			$tem=0;
				foreach ($cisis as $cisiswa) {
					$spp = 0;
					
					$spp = $this->rep_sis->get_total_spp($v_siswa['id_daftar'], $cisiswa['id']);	
					$total_all = $total_all+$spp;
					if($tem==0){
						$html .='<td>'.$cisiswa['jenis_pembayaran'].'</td>';	
						if($spp==0){
							$html .='<td style="text-align:right;">Rp. - </td></tr>';
						}else{		
							$html .='<td style="text-align:right;">Rp. '.number_format($spp,2,",",".").'</td></tr>';
						}
						$tem=$tem+1;
					}else{
						$html .='<tr><td>'.$cisiswa['jenis_pembayaran'].'</td>';	
						if($spp==0){
							$html .='<td style="text-align:right;">Rp. - </td></tr>';
						}else{		
							$html .='<td style="text-align:right;">Rp. '.number_format($spp,2,",",".").'</td></tr>';
						}
					}
				}			
			/******************/
			
		}
		
		/*
		$html .= '<tr><td style="text-align:center; font-weight: bold;" colspan="3" >JUMLAH</td>';
		
		$spp_harian = $this->rep_sis->total_spp_harian($periode);
		$html .= '<td style="text-align:right;">Rp. '.number_format($total_spp,2,",",".").'</td>';
		
		
		
		$smk = $this->input->post("smk");
		
		foreach ($header as $vheader) {
				if((empty($smk))||($smk=='')){
					$otal_daily = $this->rep_sis->get_total_trans_harian($vheader['jenispembayaran'],$periode,'');
					//if($vheader['id_smk']==$otal_daily->id_smk){
					$html .='<td style="text-align:right;"><b>Rp. '.number_format($otal_daily->total,2,",",".").'</b></td>';
					//}else{
					//	$html .='<td style="text-align:right;"><b>Rp. test </b></td>';
					//}
						
				}else{
					$otal_daily = $this->rep_sis->get_total_trans_harian($vheader['jenispembayaran'],$periode,$smk);
					//if($vheader['id_smk']==$otal_daily->id_smk){
						$html .='<td style="text-align:right;"><b>Rp. '.number_format($otal_daily->total,2,",",".").'</b></td>';
					//}else{
					//	$html .='<td style="text-align:right;"><b>Rp. - </b></td>';
					//}
				}
				
		}
		*/
		/**********************/
		
		/*Summary Closing*/
		//$html .='<td style="text-align:right;"><b>Rp. '.number_format($total_all,2,",",".").'</b></td></tr>';
		/*****************/
		$html .= '</tbody>';
		$html .= '</table>';
		//$html = "Peiode -- ".$periode;
		$html .= '<script>
					var name = "DailyTrans.xls";
					$("#save_excell").on("click", function () {
						var uri = $("#activity_table").btechco_excelexport({
						containerid: "activity_table"
						, datatype: $datatype.Table
						, returnUri: true
						});
				$(this).attr("download", name).attr("href", uri).attr("target", "_blank");
			});
		</script>';
		echo $html;
	}
	
	
	function getJurusan() {
		$id_smk = $this->input->post("smk");
		$options = $this->rep_sis->getJurusan($id_smk);
	
		$html = '<label class="select">
						<select name="id_mapping_jur" style="width:195px;" class="chosen-select" id="id_mapping_jur" onchange="cekKelas(this.value);getRuang();">
							<option value="">--Semua Jurusan--</option>																
						'.$options.'
						</select> <i></i> 
					</label>';
		$html .='<script>
					$(function() {
						$(".chosen-select").chosen();
					})
				</script>';	
		echo $html;			
	}
	
	function cekKelas() {
		$options = $this->rep_sis->cekKelas();
		$id_jur = $this->input->post("id_jur");
		$html='<label class="select">
									<select name="kelas" style="width:195px;" class="chosen-select"  onchange="getRuang(this.value,'.$id_jur.');" >
									<option value="">--Semua Kelas--</option>'.$options.'</select> <i></i> 
								</label>';
		$html .='<script>
					$(function() {
						$(".chosen-select").chosen();
					})
				</script>';	
								
		echo $html;			
	}
	
	function getRuang(){
		$kelas = $this->input->post("kelas");
		$id_mapping_jur = $this->input->post("id_mapping_jur");
		
		$options = $this->rep_sis->getRuang($kelas, $id_mapping_jur);
	
		$html = '<label class="select">
						<select name="ruang"  class="chosen-select" id="id_mapping_ruang">
							<option value="">--Semua Ruang Kelas--</option>																
						'.$options.'
						</select> <i></i> 
					</label>';
		$html .='<script>
					$(function() {
						$(".chosen-select").chosen();
					})
				</script>';	
				
		echo $html;			
	}
	
	function convert_bln($month){
		$curr_bulan = $month - 6;
		if($curr_bulan <= 0){
			$curr_bulan = $month + 6;
		}
		return $curr_bulan;
	}
}
