<?php 
class Appconfig_model extends CI_Model { 
	
	function delete_data() {
		
		$del = false;
		$id_config = $this->input->post('id_config');
		if (!empty($id_config)) {
			$this->db->where("id_config",$id_config);
			$del = $this->db->delete("adm_config");
			
		}
		
		return $del;
	}
	
	function cekConfigName($conName) {
		
		$this->db->select("id_config");
		$this->db->from("adm_config");
		$this->db->where("upper(name_config)",strtoupper($conName));
		$num = $this->db->get()->num_rows();
		return $num;
		
	}
	
	function cekConfigNameUpdate($conName,$id) {
		
		//get old role 
		$this->db->select("name_config");
		$this->db->from("adm_config");
		$this->db->where("id_config",$id);
		$oldName = $this->db->get()->row()->name_config;
		if (strtoupper($oldName) == strtoupper($conName)) {
			$num = 0;
		} else {
			
			$this->db->select("id_config");
			$this->db->from("adm_config");
			$this->db->where("upper(name_config)",strtoupper($conName));
			$num = $this->db->get()->num_rows();
			
		}		
		return $num;
	}
	
	
	function insert_data() {
		
		$data['name_config'] 	= strtoupper($this->input->post('name_config'));
		$data['value_config']	= $this->input->post('value_config');
		$data['desc_config']	= $this->input->post('desc_config');
		$data['created_date']	= date("Y-m-d H:i:s");
		$data['created_by']		= $this->session->userdata('username');
		
		$q = $this->db->insert('adm_config',$data);
		return $q;	
		
	}
	
	function update_data() {
		
		$id = $this->input->post('id_config');
		
		$data['name_config'] 	= strtoupper($this->input->post('name_config'));
		$data['value_config']	= $this->input->post('value_config');
		$data['desc_config']	= $this->input->post('desc_config');
		$data['modified_date']	= date("Y-m-d H:i:s");
		$data['modified_by']	= $this->session->userdata('username');
		
		$this->db->where('id_config',$id);
		$q = $this->db->update('adm_config',$data);
		return $q;	
		
	}
	
	function get_value_edit($id) {
		$this->db->select('*');
		$this->db->from('adm_config');
		$this->db->where('id_config',$id);
		$data = $this->db->get()->row();
		return $data;
	}
	
	function get_list_data() {
	
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		 $table = 'adm_config'; 
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
                $sql = "select id_config, name_config, desc_config, value_config, created_by, created_date, modified_by, modified_date from $table  order by id_config limit ?, ?";
                $sqlcount = "select id_config from $table";
            } else {
                $sql = "select id_config, name_config, desc_config, value_config, created_by, created_date, modified_by, modified_date from $table  $cond order by id_config limit ?, ?";
                $sqlcount = "select id_config from $table $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select id_config, name_config, desc_config, value_config, created_by, created_date, modified_by, modified_date from $table order by $sort $order limit ?, ?";
                $sqlcount = "select id_config from $table";
            } else {
                $sql = "select id_config, name_config, desc_config, value_config, created_by, created_date, modified_by, modified_date from $table  $cond order by $sort $order limit ?, ?";
                $sqlcount = "select id_config from $table  $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}

}