<?php 

class Role_assigment_model extends CI_Model {

	function delete_data() {
		
		$del = false;
		$id = $this->input->post('id');
		if (!empty($id)) {
			$this->db->where("id",$id);
			$del = $this->db->delete("adm_roles_assignment");			
		}
		
		return $del;
	}
	
	function get_list_data() {
		//echo "here"; die();
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
				$sql = "select id, privilage_view, privilage_create, privilage_update, privilage_delete, created_by,
				created_date, modified_by, modified_date, menu_name, role_name
				from v_assigment order by id limit ?, ?";
                $sqlcount = "select id from v_assigment";
            } else {
                $sql = "select 
				id, privilage_view, privilage_create, privilage_update, privilage_delete, created_by,
				created_date, modified_by, modified_date, menu_name, role_name
				from v_assigment			
				$cond order by id limit ?, ?";
                $sqlcount = "select id from v_assigment $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select id, privilage_view, privilage_create, privilage_update, privilage_delete, created_by,
				created_date, modified_by, modified_date, menu_name, role_name from v_assigment
				order by $sort $order limit ?, ?";
                $sqlcount = "select id from v_assigment";
            } else {
                $sql = "select id, privilage_view, privilage_create, privilage_update, privilage_delete, created_by,
				created_date, modified_by, modified_date, menu_name, role_name from v_assigment
				$cond order by $sort $order limit ?, ?";
                $sqlcount = "select id from v_assigment $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	
	
	function insert_data() {
		
		$view = '';
		if (!empty($this->input->post('privilage_view'))) {
			$view = $this->input->post('privilage_view');
		}
		
		$data['role_id'] 				= $this->input->post('role_id');
		$data['menu_id']				= $this->input->post('menu_id');
		
		if ($view == 'Y') {
			$data['privilage_view']			= $this->input->post('privilage_view');
			$data['privilage_create']		= $this->input->post('privilage_create');
			$data['privilage_update']		= $this->input->post('privilage_update');
			$data['privilage_delete']		= $this->input->post('privilage_delete');
			$data['privilage_approve']		= $this->input->post('privilage_approve');
		} else {
			$data['privilage_view']			= 'N';
			$data['privilage_create']		= 'N';
			$data['privilage_update']		= 'N';
			$data['privilage_delete']		= 'N';
			$data['privilage_approve']		= 'N';
		}
		
		$data['created_date']			= date("Y-m-d H:i:s");
		$data['created_by']				= $this->session->userdata('username');
		
		$q = $this->db->insert('adm_roles_assignment',$data);
		return $q;	
		
	}
	
	function update_data() {
		
		$id = $this->input->post('id');
		
		$view = '';
		if (!empty($this->input->post('privilage_view'))) {
			$view = $this->input->post('privilage_view');
		}
		
		$data['role_id'] 				= $this->input->post('role_id');
		$data['menu_id']				= $this->input->post('menu_id');
		
		if ($view == 'Y') {
			$data['privilage_view']			= $this->input->post('privilage_view');
			$data['privilage_create']		= $this->input->post('privilage_create');
			$data['privilage_update']		= $this->input->post('privilage_update');
			$data['privilage_delete']		= $this->input->post('privilage_delete');
			$data['privilage_approve']		= $this->input->post('privilage_approve');
		} else {
			$data['privilage_view']			= 'N';
			$data['privilage_create']		= 'N';
			$data['privilage_update']		= 'N';
			$data['privilage_delete']		= 'N';
			$data['privilage_approve']		= 'N';
		}
		
		$data['modified_date']			= date("Y-m-d H:i:s");
		$data['modified_by']				= $this->session->userdata('username');
		
		$this->db->where('id',$id);
		$q = $this->db->update('adm_roles_assignment',$data);
		return $q;	
		
	}
	
	function get_value_edit($id) {
		
		$this->db->select('*');
		$this->db->from('adm_roles_assignment');
		$this->db->where('id',$id);
		$data = $this->db->get()->row();
		return $data;
		
	}
	
	function get_role() {
	
		$this->db->select("role_id,role_name");
		$this->db->from("adm_roles");
		$data = $this->db->get()->result_array();
		return $data;
		
	}
	
	function get_menu($role_id) {
		
		$return = '';
		/* $this->db->select("menu_id,menu_name");
		$this->db->from("adm_menus");
		$data = $this->db->get()->result_array();
		 */
		 $q = $this->db->query("
			SELECT 
				CONCAT(REPEAT('&nbsp;&nbsp;&nbsp;|-&nbsp;&nbsp;&nbsp;', level - 1), 
				CAST(hi.menu_name AS CHAR)) AS menu_name,			
				hi.menu_id
			FROM (  SELECT 
						hierarchy_connect_by_parent_eq_prior_id(menu_id) AS menu_id, 
						@level AS level 
					FROM ( 
							SELECT @start_with := 0, 
							@id := @start_with, 
							@level := 0 
						 ) vars, 
					adm_menus WHERE @id IS NOT NULL
				  ) ho 
				  JOIN adm_menus hi ON hi.menu_id = ho.menu_id
		 ");
		 $data = $q->result_array();
		foreach ($data as $menu) {
			$cek = $this->cek_role_exist($menu['menu_id'],$role_id);
			if ($cek == 0) {
				$return  .= '<option value="'.$menu['menu_id'].'">'.$menu['menu_name'].'</option>';
			}			 
		}
		
		return $return;
	}
	
	function cek_role_exist($menu_id,$role_id) {
		$this->db->select("id");
		$this->db->from("adm_roles_assignment");
		$this->db->where(
			array(
				'menu_id'=>$menu_id,
				'role_id'=>$role_id
			)
		);
		$num = $this->db->get()->num_rows();
		return $num;	
	}
	
	function get_value_menu($menu_id) {
	
		$this->db->select("menu_id,menu_name");
		$this->db->from("adm_menus");
		$this->db->where("menu_id",$menu_id);
		$data = $this->db->get()->row();
		return $data;
	}

}