<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rep_ppdb extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('rep_ppdb_model', 'rep_sis');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	
	public function index()	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
		
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			$act = base_url()."index.php/".$this->gparam['controller']."/load_data";
			
			$excell_download = '<a class="btn btn-success" id="save_excell" href="#" >
								<i class="fa fa-lg fa-fw fa-download"></i>Excell
							  </a>';		

			$get_smk = $this->rep_sis->getDataSMK();
			$nama_smk='	<select name="smk" class="chosen-select" style="width:195px;">
									<option value="">--Semua Sekolah--</option>';
					
			foreach ($get_smk as $v_smk) {
				$nama_smk .='<option value="'.$v_smk['id'].'">'.$v_smk['name'].'</option>';
			}
			$nama_smk .='</select> ';
			
			// pnumber, psize
			$data = array(
					'controller'  	=> $this->gparam['controller'],
					'psize'			=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  		=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'excell' 		=> $excell_download,
					'nama_smk' 		=> $nama_smk,
					'action'		=> $act
			);
			
			$this->load->view('rep_ppdb_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	
	function load_data() {
	
		/* $periode = $this->input->post("periode");
		$until = $this->input->post("until");
	    $get_id_siswa = $this->rep_sis->get_id_siswa($peride,$until);
		 */
		
		$periode = $this->input->post("periode");	
		$smk = $this->input->post("smk");
		if((empty($smk))||($smk=='')){
			$get_id_siswa = $this->rep_sis->get_id_siswa($periode, '');
		}else{
			$get_id_siswa = $this->rep_sis->get_id_siswa($periode, $smk);
		}
		
		
		
		
		/*Header*/
		$html = '<table class="table table-bordered" border="1" id="activity_table"><thead><tr>';
		$html .='<th style="text-align:center;">Nama</th>';
		$html .='<th style="text-align:center;">Status</th>';
		$html .='<th style="text-align:center;">Sekolah</th>';
		$html .='<th style="text-align:center;">Nama Cicilan</th>';
		$html .='<th style="text-align:center;">Total Pembayaran Cicilan PPDB</th>';
		
		$html .= '</tr></thead>';
		
		
		$html .= '<tbody>';
		/*Close Header*/
		
		
		$total_all = 0;
		foreach ($get_id_siswa as $v_siswa) {
			if($v_siswa['sts_ppdb']==0){
				
				$trans = 0;
				/*Get Detail Siswa*/
				$jum_sc = $this->rep_sis->get_count_cicilan_siswa($v_siswa['id_siswa']);
				foreach ($jum_sc as $jum_s) {
					$jum_span=$jum_s['jml'];
				}
				
				$html .='<tr><td rowspan="'.$jum_span.'">'.$this->rep_sis->get_detail($v_siswa['id_siswa']).'</td>';	
				
				$html .='<td rowspan="'.$jum_span.'">SISWA</td>';	
				$html .='<td rowspan="'.$jum_span.'">'.$this->rep_sis->get_ruang_kelas($v_siswa['id_siswa']).'</td>';	
						
				/******************/
				
				/*Get Detail SPP Siswa*/
				
				$cisis = $this->rep_sis->get_cicilan_siswa($v_siswa['id_siswa']);
				$tem=0;
				foreach ($cisis as $cisiswa) {
					$spp = 0;
					
					$spp = $this->rep_sis->get_total_spp($v_siswa['id_siswa'], $cisiswa['id'],$v_siswa['mk']);	
					if($v_siswa['mk']==0){
						$total_all = $total_all+$spp;
					}else{
						$total_all = $total_all-$spp;
					}
					
					if($tem==0){
						if($v_siswa['mk']=='0'){
							$html .='<td>'.$cisiswa['jenis_pembayaran'].'</td>';	
							if($spp==0){
								$html .='<td style="text-align:right;">Rp. - </td></tr>';
							}else{		
								$html .='<td style="text-align:right;">Rp. '.number_format($spp,2,",",".").'</td></tr>';
							}
						}else{
							$html .='<td>Pengembalian DSP</td>';
							if($spp==0){
								$html .='<td style="text-align:right;">Rp. - </td></tr>';
							}else{		
								$html .='<td style="text-align:right;">(Rp. '.number_format($spp,2,",",".").')</td></tr>';
							}	
						}
						
						$tem=$tem+1;
					}else{
						$html .='<tr><td>'.$cisiswa['jenis_pembayaran'].'</td>';	
						if($spp==0){
							$html .='<td style="text-align:right;">Rp. - </td></tr>';
						}else{		
							$html .='<td style="text-align:right;">Rp. '.number_format($spp,2,",",".").'</td></tr>';
						}
					}
				}
			}else{
				
				$jum_sc = $this->rep_sis->get_count_cicilan_siswa_ppdb($v_siswa['id_siswa']);
				foreach ($jum_sc as $jum_s) {
					$jum_span=$jum_s['jml'];
				}
				
				
				$html .='<tr><td rowspan="'.$jum_span.'">'.$this->rep_sis->get_detail_ppdb($v_siswa['id_siswa']).'</td>';	
				$html .='<td rowspan="'.$jum_span.'">PPDB</td>';	
				$html .='<td rowspan="'.$jum_span.'">'.$this->rep_sis->get_ruang_kelas_ppdb($v_siswa['id_siswa']).'</td>';
				
				$cisis = $this->rep_sis->get_cicilan_siswa_ppdb($v_siswa['id_siswa']);
				$tem=0;
				foreach ($cisis as $cisiswa) {
					$spp = 0;
					//$html .='<td>'.$cisiswa['jenis_pembayaran'].'</td>';	
					$spp = $this->rep_sis->get_total_spp_ppdb($v_siswa['id_siswa'], $cisiswa['id'],$v_siswa['mk']);	
					if($v_siswa['mk']==0){
						$total_all = $total_all+$spp;
					}else{
						$total_all = $total_all-$spp;
					}
					if($tem==0){
						if($v_siswa['mk']=='0'){
							$html .='<td>'.$cisiswa['jenis_pembayaran'].'</td>';
							if($spp==0){
								$html .='<td style="text-align:right;">Rp. - </td></tr>';
							}else{		
								$html .='<td style="text-align:right;">Rp. '.number_format($spp,2,",",".").'</td></tr>';
							}
						}else{
							$html .='<td>Pengembalian DSP</td>';
							if($spp==0){
								$html .='<td style="text-align:right;">Rp. - </td></tr>';
							}else{		
								$html .='<td style="text-align:right;">(Rp. '.number_format($spp,2,",",".").')</td></tr>';
							}
						}
						
						$tem=$tem+1;
					}else{
						$html .='<tr><td>'.$cisiswa['jenis_pembayaran'].'</td>';
						if($spp==0){
							$html .='<td style="text-align:right;">Rp. - </td></tr>';
						}else{		
							$html .='<td style="text-align:right;">Rp. '.number_format($spp,2,",",".").'</td></tr>';
						}
					}
				}
				
				
			}
		}
		
		
		$html .= '<tr><td style="text-align:center; font-weight: bold;" colspan="4" >JUMLAH</td>';
		/*Total SPP Harian*/
		$spp_harian = $this->rep_sis->total_spp_harian($periode);
		$html .= '<td style="text-align:right;"><b>Rp. '.number_format($total_all, 2,",",".").'</b></td></td>';
		/*****************/
		
		
		$smk = $this->input->post("smk");
		
		/*****************/
		$html .= '</tbody>';
		$html .= '</table>';
		//$html = "Peiode -- ".$periode;
		$html .= '<script>
					var name = "DailyTrans.xls";
					$("#save_excell").on("click", function () {
						var uri = $("#activity_table").btechco_excelexport({
						containerid: "activity_table"
						, datatype: $datatype.Table
						, returnUri: true
						});
				$(this).attr("download", name).attr("href", uri).attr("target", "_blank");
			});
		</script>';
		echo $html;
	}
	
	
}
