<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Trans_spp_ppdb extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('trans_spp_ppdb_model', 'spp_model');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	public function index()
	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			
			$create_button = '""';			
			$update_button = '';
			$delete_button = '';		
			$preview = '';		
			
			if ($this->gparam['privilage']->privilage_create == 'Y') {
				//create button
				$create_button = '<a href="javascript:void(0)"  class="btn btn-primary btn-xs" onclick="create_view();" >
									<i class="fa fa-lg fa-fw fa-plus"></i>Create
								  </a>';
			}

			$cetakFaktur = "<a cstyle=\"margin:4px;\" class=\"btn btn-success btn-xs\" onclick=\"cetakFaktur(\''+row.no_faktur+'\')\" href=\"javascript:void(0)\"\
								group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-print fa-lg\"></i>\
							  </a>";		
			
			/* if ($this->gparam['privilage']->privilage_update == 'Y') {
				$update_button = "<a class=\"l-btn l-btn-small l-btn-plain\" onclick=\"edit_view(\''+row.no_faktur+'\')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-pencil fa-lg\"></i>\
								  </a>";
			}
			

			if ($this->gparam['privilage']->privilage_delete == 'Y') {	
				$delete_button = "<a class=\"l-btn l-btn-small l-btn-plain\" onclick=\"delete_data('+row.no_faktur+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Delete\">\
									<i class=\"fa fa-trash-o  fa-lg\"></i>\
								</a>"; 
			}		 */

			
			
			// pnumber, psize
			$data = array(
					'controller'  			=> $this->gparam['controller'],
					'psize'  				=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  				=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'create' 				=> $create_button,
					'cetakFaktur' 			=> $cetakFaktur
			);
			
			$this->load->view('trans_spp_ppdb_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	
	
	function form() {
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			$data['controller'] = $this->gparam['controller'];				
			$data['action'] = base_url()."index.php/".$this->gparam['controller']."/crud";
			$no_trans = $this->uri->segment(3);	
			//echo $no_trans;
						
			if (!empty($no_trans)) {
				
				if ($this->gparam['privilage']->privilage_update == 'Y') {				
					echo $this->gparam['restrict']; die();
				} else {
					echo $this->gparam['restrict']; die();
				}
				
			} else {
				
				if ($this->gparam['privilage']->privilage_create == 'Y') {	
								
					$last_id = $this->spp_model->get_last_seq();
					
					$last_id = $last_id + 1;
					$length = strlen($last_id);
					
					if ($length == 1) {
						$num = '0000';
					} else if ($length == 2){
						$num = '000';
					} else if ($length == 3) {
						$num = '00';
					}else if ($length == 4) {
						$num = '0';
					
					} else {
						$num = '';
					}
					
					$tahunAjaran = $this->spp_model->get_tahun_ajaran();
					$get_siswa = $this->spp_model->getSiswa($tahunAjaran);
					
					$s_siswa = '';
					foreach($get_siswa as $val_siswa) {
						$s_siswa .= '<option value="'.$val_siswa['id_siswa'].'">'.$val_siswa['nama'].' </option>';
					}
					
					
					$data['num'] = 1;
					$data['last_id'] = $last_id;
					$data['faktur']  = '<input id="no_transaksi" type="text" name="no_transaksi"  value="FM'.date('Ymd').$num.$last_id.'" readonly />'; 
					
					$data['header']  = 'Add SPP';
					$data['submit']  = 'create';		
					$data['bulan'] ='							
										<section class="col col-6">
											<label class="label">Bulan</label>
											<label class="select">	
												<select id="bulan" name="bulan[]" class="chosen-select" multiple onchange="countBulan()" >																											
												</select>												
											</label>
										</section>										
									';
					
						
					$get_smk = $this->spp_model->getDataSMK();
					$nama_smk='<label class="select">
									<select name="smk" onchange="getNama(this.value), getThnAj(0), getBesarnya(this.value,0000/0000), getBulan(this.value,0000/0000), getTotal(this.value,0000/0000)" >
									<option value="">--Select--</option>';
					
					foreach ($get_smk as $v_smk) {
						//for($i=0;$i<$temp_i;$i++){
							//if($edit->kelas==$v_smk['name']){
							//	$nama_smk .='<option value="'.$v_smk['name'].'" selected>'.$v_smk['name'].'</option>';
							//}else{
								$nama_smk .='<option value="'.$v_smk['id'].'">'.$v_smk['name'].'</option>';
							//}
						//}
						
					}
					$nama_smk .='</select> <i></i> 
								</label>';
								
					$data['nama_smk']=$nama_smk;
					
					
					$id_siswa = '<section class="col col-4">
							<div id="b_detail">
								<label class="label">Nama Siswa</label>
								<label class="select">
									<select name="id_siswa" onchange="getThnAj(this.value),getBesarnya(this.value,"-"),getTotal(this.value,"-"),getBulan(this.value,"-")" class="chosen-select">
										<option value="">--Select--</option>		
									</select>
									<i></i>		
								</label>
							</div>
						</section>'; 
			
			
					//$get_thn = $this->spp_model->getThn();
					$thn_ajaran='<label class="select" >
									<select name="thn" class="chosen-select">
									<option value="">--Select--</option>';
					/*
					foreach ($get_thn as $v_thn) {
						//for($i=0;$i<$temp_i;$i++){
							//if($edit->kelas==$v_smk['name']){
							//	$nama_smk .='<option value="'.$v_smk['name'].'" selected>'.$v_smk['name'].'</option>';
							//}else{
								$thn_ajaran .='<option value="'.$v_thn['tahun_ajaran'].'">'.$v_thn['tahun_ajaran'].'</option>';
							//}
						//}
						
					}
					*/
					$thn_ajaran .='</select> <i></i> 
								</label>';
								
					$data['thn_ajaran']=$thn_ajaran;
					
				} else {
					echo $this->gparam['restrict']; die();
				}	
			}
			
			
			$data['id_siswa'] = $id_siswa;			
			$this->load->view('crud_trans_spp_ppdb',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	function getBulan() {
		$thn = $this->input->post("thn");
		$id = $this->input->post("id");
		$val = $this->spp_model->getBulan($id,$thn);
		
		$html = '<section class="col col-6">
					<label class="label">Bulan</label>
					<label class="select">	
						<select id="bulan" name="bulan[]" class="chosen-select" multiple onchange="countBulan()" >	
						'.$val.'	
						</select>						
					</label>
				</section>';
				
		$html .='<script>
					$(function() {
						$(".chosen-select").chosen();
					})
				</script>';		
		echo $html;				
	
	}

	
	function countTotal() {
	
		$num = $this->input->post('num');
		$besarnya = $this->input->post('besarnya');
		
		$total = $num * $besarnya;
		
		echo '<input id="totalBayar" type="text" name="totalBayar"  value="Rp '.number_format($total,2,",",".").'" readonly="readonly" />';
		
		
	}
	
	function getThnAj(){
		//$id_siswa = $this->input->post('id');
		$id = $this->input->post("id");
		//echo $id; die();
		$options  = $this->spp_model->getThn($id);
		
		$html = '<label class="select">
<select name="thn" class="chosen-select" onchange="getBesarnya('.$id.',this.value),getTotal(this.value),getBulan('.$id.', this.value)">
										<option value="">--Select--</option>
										'.$options.'		
									</select>
									<i></i>		
								</label>';
		$html .='<script>
					$(function() {
						$(".chosen-select").chosen();
					})
				</script>';	
		echo $html;	
								
	}
	function getBesarnya() {
		$html='';
		$id_siswa = $this->input->post('id');
		$thn = $this->input->post('thn');
		$besarnya = $this->spp_model->getBesarnya($id_siswa, $thn);
		$besarTabsis = $this->spp_model->getBesarnyaTabsis($id_siswa, $thn);
		$kd 	  = $this->spp_model->getKode($id_siswa);
		$kd_tabsis 	  = $this->spp_model->getKodeTabsis($id_siswa);
		
		//echo number_format($besarnya,2,",","."); die();
		$html .= '<input id="besarnyaShow" type="text" name="besarnyaShow"  value="SPP = Rp '.number_format($besarnya,2,",",".").', Tabsis = Rp '.number_format($besarTabsis,2,",",".").'" readonly="readonly" />';
		$html .= '<input id="besarnyaspp" type="hidden" name="besarnyaspp"  value="'.$besarnya.'" readonly="readonly" />';
		$html .= '<input id="besarnyatabsis" type="hidden" name="besarnyatabsis"  value="'.$besarTabsis.'" readonly="readonly" />';
		$html .= '<input id="besarnya" type="hidden" name="besarnya"  value="'.($besarnya+$besarTabsis).'" readonly="readonly" />';
		
		if ($kd != '0') {
			//SPP
			$html 	  .= '<input id="kodedesk" type="hidden" name="kodedesk" value="'.$kd->kodedesk.'" readonly="readonly" />';
			$html 	  .= '<input id="kodesub" type="hidden" name="kodesub" value="'.$kd->kodesub.'" readonly="readonly" />';
			
			//TABSIS
			$html 	  .= '<input id="kodedesk_tabsis" type="hidden" name="kodedesk_tabsis" value="'.$kd_tabsis->kodedesk.'" readonly="readonly" />';
			$html 	  .= '<input id="kodesub_tabsis" type="hidden" name="kodesub_tabsis" value="'.$kd_tabsis->kodesub.'" readonly="readonly" />';		
		}
		
		echo $html;
	}
	
	function getTotal() {
		$id_siswa = $this->input->post('id');
		$thn = $this->input->post('thn');
		$besarnya = $this->spp_model->getBesarnya($id_siswa, $thn);
		
		//echo '<input id="totalBayar" type="text" name="totalBayar"  value="'.$besarnya.'" readonly="readonly" />';
		echo '<input id="totalBayar" type="text" name="totalBayar"  value="Rp 0.00" readonly="readonly" />';
	}
	
	public function crud() {
		
		$crud = $this->input->post('submit');
		if ($crud == 'create') {		
			//print_r($_POST); die();
			$id_fak = $this->spp_model->next_faktur();
			$insert = $this->spp_model->insert_data($id_fak);
			if ($insert) {
				
				//$faktur = $this->input->post("no_transaksi");
				$this->session->set_flashdata('faktur', $id_fak);				
				$json = true;
			}
			
		} else if ($crud == 'update') {
			echo $this->gparam['restrict']; die();
			/*$update = $this->spp_model->update_data();
			if ($update) {
				$json = true;			
			}*/
				
		}
		
		echo json_encode($json);
		
	}
	
	public function delete() {
		
		$delete = $this->spp_model->delete_data();
		if ($delete) {
			$json = true;
		}
		echo json_encode($json);	
	}
	
	function load_data() {
		
		header('Content-Type: application/jsonp');
        $list = $this->spp_model->get_list_data();		
        echo json_encode($list);
		
	}
	
	function printFaktur() {
	
		define('FPDF_FONTPATH',$this->config->item('fonts_path'));
		$faktur = $_GET['faktur'];
		$diserahkan = $this->spp_model->getDiserahkan($faktur);
		$diterima  	= $this->spp_model->getDiterima($faktur);
		$total = $this->spp_model->getTotal($faktur);
		$get = $this->spp_model->getDetailFaktur($faktur);
		$getAsalSekolah = $this->spp_model->getAsalSekolah($faktur);
		
		
		//update faktur ke cetak
		//$upStatus = $this->spp_model->updateStatusFaktur($faktur);
		
		$data = array(
			'detail' 	 => $get, 
			'total'	 	 => $total,
			'diserahkan' => $diserahkan,
			'diterima' => $diterima,
			'faktur'	 => $faktur,
			'getAsalSekolah'	 => $getAsalSekolah
		);
		
		$this->load->view("printTransSpp",$data);
	}
	
	function successPage() {
		$this->load->view("success_page");
	}
	function getNama() {
		$id_smk = $this->input->post("smk");
		
		$options = $this->spp_model->getNama($id_smk);
	//echo "test";exit(0);
		$html = '<div id="b_detail">
								<label class="label">Nama Siswa</label>
								<label class="select">
									<select name="id_siswa"  onchange="getThnAj(this.value), getBesarnya(this.value,0000/0000), getBulan(this.value,0000/0000), getTotal(this.value,0000/0000)" class="chosen-select">
										<option value="">--Select--</option>
										'.$options.'		
									</select>
									<i></i>		
								</label>
							</div>';
		$html .='<script>
					$(function() {
						$(".chosen-select").chosen();
					})
				</script>';	
		echo $html;			
	}
}
