<?php 
class List_uang_masuk_model extends CI_Model {
	
	function get_desk() {
		
		$this->db->select("kodedesk,deskripsi");
		$this->db->from("ref_uang_masuk");
		$this->db->order_by("Id");
		$data = $this->db->get()->result_array();
		return $data;
		
	}
	
	function delete_data() {
		
		$del = false;
		$id = $this->input->post('id');
		if (!empty($id)) {
			$this->db->where("id",$id);
			$del = $this->db->delete("ref_list_uang_masuk");
			
		}
		
		return $del;
	}
	
	function get_value_edit($id) {
		
		$this->db->select("*");
		$this->db->from("ref_list_uang_masuk");
		$this->db->where("id",$id);
		$data = $this->db->get()->row();
		
		return $data;
		
	}
	
	function insert_data() {
		
		$data['kodedesk'] 		= $this->input->post('kodedesk');
		$data['kodesub']		= $this->input->post('kodesub');
		$data['daftarlist']		= $this->input->post('daftarlist');
		$data['keterangan']		= $this->input->post('keterangan');
		$data['created_date']	= date("Y-m-d H:i:s");
		$data['created_by']		= $this->session->userdata('username');
		
		$q = $this->db->insert('ref_list_uang_masuk',$data);
		return $q;	
		
	}
	
	function update_data() {
		
		$id = $this->input->post('id');
		
		$data['kodedesk'] 		= $this->input->post('kodedesk');
		$data['kodesub']		= $this->input->post('kodesub');
		$data['daftarlist']		= $this->input->post('daftarlist');
		$data['keterangan']		= $this->input->post('keterangan');
		$data['modified_date']	= date("Y-m-d H:i:s");
		$data['modified_by']	= $this->session->userdata('username');
		
		$this->db->where('id',$id);
		$q = $this->db->update('ref_list_uang_masuk',$data);
		return $q;	
		
	}
	
	function get_list_data() {
	
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		 $table = 'ref_list_uang_masuk'; // table name, use for only one table
        // $table_image = 'wb_image_bird';
        if (empty($param['sort'])) {
            if (empty($cond)) {
                $sql = "select id, kodedesk, kodesub, daftarlist, keterangan, created_by, created_date, modified_by, modified_date from $table  order by kodedesk asc, kodesub asc limit ?, ?";
                $sqlcount = "select * from $table";
            } else {
                $sql = "select id, kodedesk, kodesub, daftarlist, keterangan, created_by, created_date, modified_by, modified_date from $table  $cond order by kodedesk asc, kodesub asc limit ?, ?";
                $sqlcount = "select * from $table $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select id, kodedesk, kodesub, daftarlist, keterangan, created_by, created_date, modified_by, modified_date from $table a order by $sort $order limit ?, ?";
                $sqlcount = "select id from $table";
            } else {
                $sql = "select id, kodedesk, kodesub, daftarlist, keterangan, created_by, created_date, modified_by, modified_date from $table  $cond order by $sort $order limit ?, ?";
                $sqlcount = "select id from $table  $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	
}