<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ref_spp extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('ref_spp_model', 'spp_model');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	public function index()
	{
		
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			
			$create_button = '""';			
			$update_button = '';
			$delete_button = '';		
						
			if ($this->gparam['privilage']->privilage_create == 'Y') {
				//create button
				$create_button = '<a href="javascript:void(0)"  class="btn btn-primary btn-xs" onclick="create_view();" >
									<i class="fa fa-lg fa-fw fa-plus"></i>Create
								  </a>';
			}	
			
			if ($this->gparam['privilage']->privilage_update == 'Y') {
				$update_button = "<a style=\"margin:4px;\" class=\"btn btn-success btn-xs\" onclick=\"edit_view('+row.id+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-lg fa-fw fa-edit\"></i>\
								  </a>";
			}
			
			if ($this->gparam['privilage']->privilage_delete == 'Y') {	
				$delete_button = "<a style=\"margin:4px;\" class=\"btn btn-danger btn-xs\" onclick=\"delete_data('+row.id+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Delete\">\
									<i class=\"fa fa-lg fa-fw fa-trash-o\"></i>\
								</a>"; 
			}
			
			// pnumber, psize
			$data = array(
					'controller'  			=> $this->gparam['controller'],
					'psize'  				=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  				=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'create' 				=> $create_button,
					'update' 				=> $update_button,
					'delete'				=> $delete_button
			);
			
			$this->load->view('ref_spp_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
		
	}
	
	function form() {
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			$data['controller'] = $this->gparam['controller'];				
			$data['action'] = base_url()."index.php/".$this->gparam['controller']."/crud";
			$id = $this->uri->segment(3);	
			
			if (!empty($id)) {
				if ($this->gparam['privilage']->privilage_update == 'Y') {				
					//get value for edit
					$edit = $this->spp_model->get_value_edit($id);
					
					$valKdsub				= $edit->kodesub;
					$data['ref_name'] 		= $edit->ref_name;
					$data['besarnya'] 		= $edit->besarnya;
					$data['id'] 			= $id;
					
					$ge_sub = $this->spp_model->get_kodesub();
					$kd_sub = '';
					
					foreach ($ge_sub as $val_sub) {
						if ($val_sub['kodesub'] == $valKdsub) {
							$kd_sub .= '<option value = "'.$val_sub['kodesub'].'" selected>'.$val_sub['daftarlist'].'</option>';
						} else {
							$kd_sub .= '<option value = "'.$val_sub['kodesub'].'">'.$val_sub['daftarlist'].'</option>';
						}
					}					
				
					
					$data['header'] 		= 'Edit Reference SPP';
					$data['submit'] 		= 'update';	
				} else {
					echo $this->gparam['restrict']; die();
				}	
			} else {
				if ($this->gparam['privilage']->privilage_create == 'Y') {	
					
					$ge_sub = $this->spp_model->get_kodesub();
					$kd_sub = '';
					
					foreach ($ge_sub as $val_sub) {
						$kd_sub .= '<option value = "'.$val_sub['kodesub'].'">'.$val_sub['daftarlist'].'</option>';
					}					
					
					$data['header'] = 'Add Reference SPP';
					$data['submit'] = 'create';
				} else {
					echo $this->gparam['restrict']; die();
				}	
			}
			
			$tahun_ajaran = $this->spp_model->get_tahun_ajaran();
			
			$data['tahun_ajaran'] = '<input name="tahun_ajaran" value="'.$tahun_ajaran.'" type="hidden" id="id-tahun_ajaran">';
			$data['kd_desk'] = '<input name="kodedesk" value="I" type="hidden" id="id-kodedesk">';
			$data['kd_sub']	= '<section class="col col-3">
							<label class="label">Kode Sub</label>
							<label class="select">	
								<select id="id-kodesub" name="kodesub" >
									<option value="">--Select--</option>
									'.$kd_sub.'									
								</select>
								<i></i>		
							</label>
						</section>';
					
			$this->load->view('crud_ref_spp',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	public function crud() {
		
		$crud = $this->input->post('submit');
		if ($crud == 'create') {
			
			$insert = $this->spp_model->insert_data();
			if ($insert) {
				$json = true;
			}
			
		} else if ($crud == 'update') {
			$update = $this->spp_model->update_data();
			if ($update) {
				$json = true;			
			}
				
		}
		
		echo json_encode($json);
		
	}
	
	function load_data() {
		header('Content-Type: application/jsonp');
        $list = $this->spp_model->get_list_data();
		
        echo json_encode($list);
	}
	
	public function delete() {
		
		$delete = $this->spp_model->delete_data();
		if ($delete) {
			$json = true;
		}
		echo json_encode($json);	
	}
	
	
}
