<?php 
class Ref_tabsis_model extends CI_Model {
	
	function get_tahun_ajaran() {
		
		$this->db->select("tahun_ajaran");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("status","U");
		$this->db->where("sts_ppdb","1");
		$tahun = $this->db->get()->row()->tahun_ajaran;
		return $tahun;
		
	}
	
	function delete_data() {
		
		$del = false;
		$id = $this->input->post('id');
		if (!empty($id)) {
			$this->db->where("id",$id);
			$del = $this->db->delete("ref_tabsis");
		}
		return $del;
	}
	
	function get_kodesub() {
	
		$this->db->select("kodesub,daftarlist");
		$this->db->from("ref_list_uang_masuk");
		$this->db->where("kodedesk","I");
		$this->db->where_in("kodesub",array("10","11","12"));
		$data = $this->db->get()->result_array();
		return $data;
		
	}

	
	function get_value_edit($id) {
		$this->db->select('*');
		$this->db->from('ref_tabsis');
		$this->db->where('id',$id);
		$data = $this->db->get()->row();
		return $data;
	}
	
	
	function get_list_data() {
	
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		 $table = 'ref_tabsis'; 
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
                $sql = "select * from $table  order by id limit ?, ?";
                $sqlcount = "select * from $table";
            } else {
                $sql = "select * from $table  $cond order by id limit ?, ?";
                $sqlcount = "select * from $table $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select * from $table order by $sort $order limit ?, ?";
                $sqlcount = "select id from $table";
            } else {
                $sql = "select * from $table  $cond order by $sort $order limit ?, ?";
                $sqlcount = "select id from $table  $cond";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	
	function update_data() {
		
		$id = $this->input->post('id');
		
		$data['ref_name'] 		= $this->input->post('ref_name');
		$data['besarnya'] 		= $this->input->post('besarnya');
		$data['tahun_ajaran'] 	= $this->input->post('tahun_ajaran');
		$data['kodedesk']		= $this->input->post('kodedesk');
		$data['kodesub']		= $this->input->post('kodesub');		
		$data['modified_date']	= date("Y-m-d H:i:s");
		$data['modified_by']	= $this->session->userdata('username');
		
		$this->db->where("id",$id);
		$q = $this->db->update("ref_tabsis",$data);
		
		return $q;	
		
	}
	
	function insert_data() {
		
		$data['ref_name'] 		= $this->input->post('ref_name');
		$data['besarnya'] 		= $this->input->post('besarnya');
		$data['tahun_ajaran'] 	= $this->input->post('tahun_ajaran');
		$data['kodedesk']		= $this->input->post('kodedesk');
		$data['kodesub']		= $this->input->post('kodesub');
		$data['created_date']	= date("Y-m-d H:i:s");
		$data['created_by']	= $this->session->userdata('username');
		
		$q = $this->db->insert("ref_tabsis",$data);
		
		return $q;	
		
	}
	
}