<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Rep_spp_siswa_harian extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('rep_spp_model_harian', 'rep_sis');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	
	public function index()	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
		
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			$act = base_url()."index.php/".$this->gparam['controller']."/load_data";
			
			$excell_download = '<a class="btn btn-success" id="save_excell" href="#" >
								<i class="fa fa-lg fa-fw fa-download"></i>Excell
							  </a>';		

			$get_smk = $this->rep_sis->getDataSMK();
			$nama_smk='	<select name="smk" class="chosen-select" style="width:195px;">
									<option value="">--Semua Sekolah--</option>';
					
			foreach ($get_smk as $v_smk) {
				$nama_smk .='<option value="'.$v_smk['id'].'">'.$v_smk['name'].'</option>';
			}
			$nama_smk .='</select> ';
			
			// pnumber, psize
			$data = array(
					'controller'  	=> $this->gparam['controller'],
					'psize'			=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  		=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'excell' 		=> $excell_download,
					'nama_smk' 		=> $nama_smk,
					'action'		=> $act
			);
			
			$this->load->view('rep_spp_view_harian',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	
	function load_data() {
	
		/* $periode = $this->input->post("periode");
		$until = $this->input->post("until");
	    $get_id_siswa = $this->rep_sis->get_id_siswa($peride,$until);
		 */
		
		$periode = $this->input->post("periode");
		$date = new DateTime($periode);
		$result = $date->format('d/m/Y');	
		$smk = $this->input->post("smk");
		if((empty($smk))||($smk=='')){
			$get_id_siswa = $this->rep_sis->get_id_siswa($periode, '');
		}else{
			$get_id_siswa = $this->rep_sis->get_id_siswa($periode, $smk);
		}
		$header = $this->rep_sis->get_header();
		
		/*Header*/
		$html = '<table  class="table table-bordered" id="activity_table"><thead>';
		
		$html .='<tr ><td colspan="9"><center><b>PESAT</b></center></td></tr>';
		$html .='<tr ><td colspan="9"><center><b>Report SPP Harian  (Tanggal: '.$result.')</b></center></td></tr>';
		$html .='<tr ><td colspan="9"></td></tr>';
		$html .='<tr><th style="text-align:center;">No</th>';
		$html .='<th style="text-align:center;">No. Faktur</th>';
		
		$html .='<th style="text-align:center;">Tanggal Transaksi</th>';
		$html .='<th style="text-align:center;">Nama</th>';
		$html .='<th style="text-align:center;">NIS</th>';
		$html .='<th style="text-align:center;">Sekolah</th>';
		
		$html .='<th style="text-align:center;">Kelas</th>';
		$html .='<th style="text-align:center;">Pembayaran untuk Bulan</th>';
		$html .='<th style="text-align:center;">Total SPP</th>';
		
		$html .= '</tr></thead>';
		$html .= '<tbody>';
		/*Close Header*/
		
		$total_all = 0;
		$spp = 0;
		$trans = 0;
		$i=1;
		foreach ($get_id_siswa as $v_siswa) {
			if($v_siswa['sts_ppdb']==0){
				$data_spp = $this->rep_sis->get_total_spp($v_siswa['id_siswa'], $periode);
				$numrowspp = $this->rep_sis->get_numrow_spp($v_siswa['id_siswa'], $periode);
				
				$temp_count=0;
				foreach ($data_spp as $d_spp) {
					$bln_all=$this->rep_sis->get_numrow_spp_bln($d_spp['no_faktur']);
					$html .='<tr>';
					$html .='<td>'.$i.'</td>';	 $i++;
					$html .='<td>'.$d_spp['no_faktur'].'</td>';	
						
					if($temp_count==0){
						/*Get Detail Siswa*/
						
						$html .='<td rowspan="'.$numrowspp.'">'.$result.'</td>';
						$html .='<td rowspan="'.$numrowspp.'">'.$this->rep_sis->get_detail($v_siswa['id_siswa'])->nama.'</td>';	
						$html .='<td rowspan="'.$numrowspp.'">'.$this->rep_sis->get_detail($v_siswa['id_siswa'])->nis.'</td>';	
						$html .='<td rowspan="'.$numrowspp.'">'.$this->rep_sis->get_ruang_kelas($v_siswa['id_siswa']).'</td>';
						$html .='<td rowspan="'.$numrowspp.'">'.$this->rep_sis->get_kelas($v_siswa['id_siswa'])->kelas.' '.$this->rep_sis->get_kelas($v_siswa['id_siswa'])->nama_jurusan.' '.$this->rep_sis->get_kelas($v_siswa['id_siswa'])->ruang_kelas.'</td>';
					}
				
								
					/******************/
					
					/*Get Detail SPP Siswa*/
					$html .='<td>'.$bln_all.'</td>';	
					$spp = $d_spp['total'];			
					$html .='<td style="text-align:right;">Rp. '.number_format($spp,2,",",".").'</td>';
					$temp_count++;
				}
				/*****************/
			}else{
				$data_spp = $this->rep_sis->get_total_spp_ppdb($v_siswa['id_siswa'], $periode);
				$numrowspp = $this->rep_sis->get_numrow_spp_ppdb($v_siswa['id_siswa'], $periode);
				
				$temp_count=0;
				
				foreach ($data_spp as $d_spp) {
					$bln_all=$this->rep_sis->get_numrow_spp_bln_ppdb($d_spp['no_faktur']);
					$html .='<tr>';
					$html .='<td valign="top">'.$i.'</td>';	 $i++;
					$html .='<td valign="top">'.$d_spp['no_faktur'].'</td>';	
						
					if($temp_count==0){
						/*Get Detail Siswa*/
						
						$html .='<td rowspan="'.$numrowspp.'" valign="top">'.$result.'</td>';
						$html .='<td rowspan="'.$numrowspp.'" valign="top">'.$this->rep_sis->get_detail_ppdb($v_siswa['id_siswa'])->nama.'</td>';	
						$html .='<td rowspan="'.$numrowspp.'" valign="top"> PPDB </td>';	
						$html .='<td rowspan="'.$numrowspp.'" valign="top">'.$this->rep_sis->get_ruang_kelas_ppdb($v_siswa['id_siswa']).'</td>';
						$html .='<td rowspan="'.$numrowspp.'" align="center" valign="top"> - </td>';
					}
				
								
					/******************/
					
					/*Get Detail SPP Siswa*/
					$html .='<td>'.$bln_all.'</td>';	
					$spp = $d_spp['total'];			
					$html .='<td style="text-align:right;" valign="top">Rp. '.number_format($spp,2,",",".").'</td>';
					$temp_count++;
				}
			}
			
		}
		
		
		$html .= '<tr><td style="text-align:center; font-weight: bold;" colspan="8" >JUMLAH</td>';
		/*Total SPP Harian*/
		$spp_harian = $this->rep_sis->total_spp_harian($periode, $smk);
		$spp_harian_ppdb = $this->rep_sis->total_spp_harian_ppdb($periode, $smk);
		
		$html .= '<td style="text-align:right;"><b>Rp. '.number_format(($spp_harian+$spp_harian_ppdb),2,",",".").'</b></td></tr>';
		/*****************/
		
		
		$smk = $this->input->post("smk");
		
		/**********************/
		
		/*****************/
		$html .= '</tbody>';
		$html .= '</table>';
		//$html = "Peiode -- ".$periode;
		$html .= '<script>
					var name = "report_spp_harian'.$result.'.xls";
					$("#save_excell").on("click", function () {
						var uri = $("#activity_table").btechco_excelexport({
						containerid: "activity_table"
						, datatype: $datatype.Table
						, returnUri: true
						});
				$(this).attr("download", name).attr("href", uri).attr("target", "_blank");
			});
		</script>';
		echo $html;
	}
	
	
}
