<?php 
class Ref_cicilan_model extends CI_Model {
	
	function get_tahun_ajaran() {
		
		$this->db->select("tahun_ajaran");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("status","U");
		$this->db->where("sts_ppdb","1");
		$tahun = $this->db->get()->row();
		if(empty($tahun)){
			return '0000/0000';
		}else{
			return $tahun->tahun_ajaran;
		}
	}
	function get_list_coa($table) {
		
		$this->db->select("id,kodedesk,kodesub,daftarlist");
		$this->db->from($table);
		$this->db->where("kodedesk","II");
		$this->db->where_in("kodesub",array(2,3,4));
		$this->db->order_by("kodedesk","asc");
		$data = $this->db->get()->result_array();		
		return $data;
		
	}
	function delete_data() {
		
		$del = false;
		$id = $this->input->post('id');
		if (!empty($id)) {
			$this->db->where("id",$id);
			$del = $this->db->delete("ref_komponen_cicilan");
			
		}
		
		return $del;
	}
	
	function get_value_edit($id) {
		$this->db->select('*');
		$this->db->from('ref_komponen_cicilan');
		$this->db->where('id',$id);
		$data = $this->db->get()->row();
		return $data;
	}
	
	
	
	function get_list_data() {
		//$tahun_ajaran = $this->get_tahun_ajaran();
		
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		 $table = 'ref_komponen_cicilan'; 
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
                $sql = "SELECT a.*, b.name FROM $table a, ref_smk b WHERE a.id_smk=b.id order by a.id_smk desc, id limit ?, ?";
                $sqlcount = "SELECT a.*, b.name FROM $table a, ref_smk b WHERE a.id_smk=b.id";
            } else {
                $sql = "SELECT a.*, b.name FROM $table a, ref_smk b $cond and a.id_smk=b.id order by a.id_smk desc, id limit ?, ?";
                $sqlcount = "SELECT a.*, b.name FROM $table a, ref_smk b $cond and a.id_smk=b.id";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "SELECT a.*, b.name FROM $table a, ref_smk b WHERE a.id_smk=b.id order by $sort $order limit ?, ?";
                $sqlcount = "SELECT a.*, b.name FROM $table a, ref_smk b WHERE a.id_smk=b.id";
            } else {
                $sql = "SELECT a.*, b.name FROM $table a, ref_smk b $cond and a.id_smk=b.id order by $sort $order limit ?, ?";
                $sqlcount = "SELECT a.*, b.name FROM $table a, ref_smk b $cond and a.id_smk=b.id";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	function getDataSMK(){
		$this->db->select('*');
		$this->db->from("ref_smk");
		$num = $this->db->get()->result_array();
		return $num;
	}
	function update_data() {
		
		$id = $this->input->post('id');
		$data['no_type'] 				= $this->input->post('type_cicil');
		
		$data['t_awal'] 				= $this->input->post('tanggal_awal');
		$data['t_akhir'] 				= $this->input->post('tanggal_akhir');
		
		$data['id_smk'] 				= $this->input->post('smk');
		$data['jenis_pembayaran'] 		= $this->input->post('jenis_pembayaran');
		$data['besarnya'] 				= $this->input->post('besarnya');
		$data['tahun_ajaran'] 			= $this->get_tahun_ajaran();
		$data['id_coa'] 				= $this->input->post('id_coa');
		$data['modified_date']			= date("Y-m-d H:i:s");
		$data['modified_by']			= $this->session->userdata('username');
		
		$this->db->where("id",$id);
		$q = $this->db->update("ref_komponen_cicilan",$data);
		
		return $q;	
		
	}
	
	function insert_data() {
		$data['no_type'] 		= $this->input->post('type_cicil');
		$data['id_smk'] 		= $this->input->post('smk');
		
		$data['t_awal'] 				= $this->input->post('tanggal_awal');
		$data['t_akhir'] 				= $this->input->post('tanggal_akhir');
		$data['jenis_pembayaran'] 		= $this->input->post('jenis_pembayaran');
		$data['besarnya'] 				= $this->input->post('besarnya');
		$data['id_coa'] 				= $this->input->post('id_coa');
		$data['tahun_ajaran'] 			= $this->get_tahun_ajaran();
		$data['created_date']	= date("Y-m-d H:i:s");
		$data['created_by']	= $this->session->userdata('username');
		
		$q = $this->db->insert("ref_komponen_cicilan",$data);
		
		return $q;	
		
	}
	
}