<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ref_siswa extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('ref_siswa_model', 'ref_siswa');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	public function index()
	{
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			
			$create_button = '""';			
			$update_button = '';
			$delete_button = '';		
						
			if ($this->gparam['privilage']->privilage_create == 'Y') {
				$create_button = '<a href="javascript:void(0)"  class="btn btn-primary btn-xs" onclick="create_view();" >
									<i class="fa fa-lg fa-fw fa-plus"></i>Create
								  </a>';
			}	
			
			if ($this->gparam['privilage']->privilage_update == 'Y') {
				$update_button = "<a style=\"margin:4px;\" class=\"btn btn-success btn-xs\" onclick=\"edit_view('+row.id_siswa+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-lg fa-fw fa-edit\"></i>\
								  </a>";
			}
			
			$image_button = "<a class=\"btn btn-primary btn-xs\" onclick=\"preview_image('+row.id_siswa+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Preview\"><i class=\"fa fa-camera-retro fa-lg\"></i>\
								  </a>";	

			
			if ($this->gparam['privilage']->privilage_delete == 'Y') {	
				$delete_button = "<a style=\"margin:4px;\" class=\"btn btn-danger btn-xs\" onclick=\"delete_data('+row.id_siswa+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Delete\">\
									<i class=\"fa fa-lg fa-fw fa-trash-o\"></i>\
								</a>"; 
			}
			/*
			$approval_button = "<a class=\"l-btn l-btn-small l-btn-plain\" onclick=\"approve_data('+row.id_siswa+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Approval\">\
									<i class=\"fa fa-check-circle  fa-lg\"></i>\
								</a>"; 	
			*/
			// pnumber, psize
			$data = array(
					'controller'  			=> $this->gparam['controller'],
					'psize'  				=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  				=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'create' 				=> $create_button,
					'update' 				=> $update_button,
					//'delete'				=> $delete_button,
					//'approval_button'		=> $approval_button,
					'image_button'			=> $image_button
			);
			
			$this->load->view('ref_siswa_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
		
	}
	
	function form() {
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			$data['controller'] = $this->gparam['controller'];				
			$data['action'] = base_url()."index.php/".$this->gparam['controller']."/crud";
			$id = $this->uri->segment(3);	
			
			if (!empty($id)) {
				if ($this->gparam['privilage']->privilage_update == 'Y') {				
					//get value for edit
					$edit = $this->ref_siswa->get_value_edit($id);
					
					$t_lahir = strtotime($edit->tanggal_lahir);
					
					$data['nama'] 			= $edit->nama;
					$data['tempat_lahir'] 	= $edit->tempat_lahir;
					$data['nisn'] 			= $edit->nisn;
					$data['nama_ayah']		= $edit->nama_ayah;
					$data['nama_ibu'] 		= $edit->nama_ibu;
					$data['nama_wali'] 		= $edit->nama_wali;
					$data['telepon_wali'] 	= $edit->telepon_wali;
					$data['telepon'] 		= $edit->telepon;
					$data['alamat'] 		= $edit->alamat;
					$data['alamat_wali'] 	= $edit->alamat_wali;
					$data['nis'] 			= $edit->nis;
					$data['tanggal_lahir'] 	= date('d-m-Y',$t_lahir);
					$data['id_siswa'] 		= $id;
					$idMappingClass			= $edit->id_mapping_kelas;
					$data['ker_ayah'] 		= $edit->pekerjaan_ayah;
					$data['ker_ibu'] 		= $edit->pekerjaan_ibu;
					$data['asal'] 			= $edit->asal_sekolah;
					$getWali = $this->ref_siswa->getWaliKelasEdit($edit->id_jur,$edit->kelas,$idMappingClass); 				
					
					$j_kel = $edit->jenis_kelamin;
					$mapping = '<div id="id-Mapping">
					<label class="select">
						<select name="id_mapping_kelas" id="id_mapping_kelas">
							<option value="">--Select--</option>
							'.$getWali.'		
						</select> <i></i> 
					</label></div>';
					
					
					if ($j_kel == 'L') {
							$jekel = '<label class="select">
									<select name="jenis_kelamin">
										<option value="">--Select--</option>
										<option value="L" selected>Laki-Laki</option>
										<option value="P">Perempuan</option>									
									</select> <i></i> 
								</label>';
					} else {
							$jekel = '<label class="select">
									<select name="jenis_kelamin">
										<option value="">--Select--</option>
										<option value="L">Laki-Laki</option>
										<option value="P" selected>Perempuan</option>									
									</select> <i></i> 
								</label>';
					}
					$get_kelas = $this->ref_siswa->getKelas($edit->id_smk);
					$kelas='<div id="id-MappingKls"><label class="select">
									<select name="kelas" onchange="getWaliKelas(this.value,'.$edit->id_jur.');" >
									<option value="">--Select--</option>';
					foreach ($get_kelas as $v_kelas) {	
						if($edit->kelas==$v_kelas['kelas']){	
							$kelas.='<option value="'.$v_kelas['kelas'].'" selected="selected">'.$v_kelas['kelas'].'</option>';
						}else{
							$kelas.='<option value="'.$v_kelas['kelas'].'">'.$v_kelas['kelas'].'</option>';
						}
						
					}
								$kelas.='</select> <i></i></label></div>';
					
					$get_smk = $this->ref_siswa->getDataSMK();
					$get_jur = $this->ref_siswa->getJurEdit($edit->id_smk);
					$nama_smk='<label class="select">
									<select name="smk" onchange="getJurusan(this.value);cekKelas(this.value),  getWaliKelas(0,0), getTypeSPP(this.value); getType(this.value);" >';
					
					foreach ($get_smk as $v_smk) {
						if($edit->id_smk==$v_smk['id']){
							$nama_smk .='<option value="'.$v_smk['id'].'" selected>'.$v_smk['name'].'</option>';
						}else{
							//$nama_smk .='<option value="'.$v_smk['id'].'">'.$v_smk['name'].'</option>';
						}
					}
					$nama_smk .='</select> <i></i> 
								</label>';
					
					if($edit->id_smk==1){
						$mappingJur = '<div id="id-MappingJur">
						<label class="select">
							<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas('.$edit->id_smk.',this.value), getWaliKelas(0,0);">
								<option value="">--Select--</option>';
								foreach ($get_jur as $v_jurusan) {
									if($edit->id_jur==$v_jurusan['id']){
										$mappingJur .='<option value="'.$v_jurusan['id'].'" selected>'.$v_jurusan['nama_jurusan'].'</option>';
									}else{
										$mappingJur .='<option value="'.$v_jurusan['id'].'">'.$v_jurusan['nama_jurusan'].'</option>';
									}
								}
																							
							$mappingJur .='</select> <i></i> 
						</label></div>';
					}else if($edit->id_smk==2){
						$mappingJur = '<div id="id-MappingJur">
						<label class="select">
							<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas('.$edit->id_smk.',this.value);">
								<option value="4" selected> - </option>';														
							$mappingJur .='</select> <i></i> 
						</label></div>';
					}else if($edit->id_smk==3){
						$mappingJur = '<div id="id-MappingJur">
						<label class="select">
							<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas('.$edit->id_smk.',this.value);">
								<option value="5" selected> - </option>';														
							$mappingJur .='</select> <i></i> 
						</label></div>';
					}
					
					
					
					$get_type = $this->ref_siswa->getTypeSPPedit($edit->id_smk);
					
					$mappingTypeSPP = '<div id="id-TypeSPP">
					<label class="select">
						<select name="id_type_spp" id="id_type_spp">
							<option value="">--Select--</option>	';
							foreach ($get_type as $v_type) {
								if($edit->id_spp_type==$v_type['id']){
									$mappingTypeSPP .='<option value="'.$v_type['id'].'" selected>'.$v_type['ref_name'].'</option>';
								}else{
									$mappingTypeSPP .='<option value="'.$v_type['id'].'">'.$v_type['ref_name'].'</option>';
								}
							}														
						$mappingTypeSPP .= '</select> <i></i> 
					</label></div>';
					
					
								
					$status = '<label class="select">
						<select name="status" id="status">
							<option value="">--Select--</option>';
					if($edit->status == 1){
						$status .='<option value="1" selected>Aktif</option>	
							<option value="0">Tidak Aktif</option>
							<option value="-1">Lulus</option>';
					}else if($edit->status == 0){
						$status .='<option value="1">Aktif</option>	
							<option value="0" selected>Tidak Aktif</option>
							<option value="-1">Lulus</option>';
					}else{
						$status .='<option value="1">Aktif</option>	
							<option value="0">Tidak Aktif</option>
							<option value="-1" selected>Lulus</option>';
					}
						$status .='</select> <i></i> 
					</label>';
					
					
					$arr_agama = array("Islam", "Kristen Protestan", "Katolik", "Hindu", "Buddha", "Kong Hu Cu");
					$agama='<label class="select">
									<select name="agama">';
					
					for($i=0; $i<6; $i++){
						if($edit->agama==$arr_agama[$i]){
							$agama.='<option value="'.$arr_agama[$i].'" selected>'.$arr_agama[$i].'</option>';
						}else{
							$agama.='<option value="'.$arr_agama[$i].'">'.$arr_agama[$i].'</option>';
						}
					}
					$agama.='</select> <i></i> 
								</label>';
								
					$get_type = $this->ref_siswa->getType($edit->id_smk);
					$mappingType = '<div id="id-MappingType">
					<label class="select">
						<select name="id_mapping_type" id="id_mapping_type">
							<option value="">--Select--</option>';
							foreach ($get_type as $v_type) {
								if($edit->no_type==$v_type['no_type']){
									$mappingType .='<option value="'.$v_type['no_type'].'" selected>'.$v_type['no_type']." - ".$v_type['jenis_pembayaran'].'</option>';
								}else{
									$mappingType .='<option value="'.$v_type['no_type'].'">'.$v_type['no_type']." - ".$v_type['jenis_pembayaran'].'</option>';
								}
							}
																						
						$mappingType .='</select> <i></i> 
					</label></div>';
						
								
					$data['header'] 		= 'Edit Master Siswa';
					$data['submit'] 		= 'update';	
				} else {
					echo $this->gparam['restrict']; die();
				}	
			} else {
				if ($this->gparam['privilage']->privilage_create == 'Y') {	
					
					$mapping = '<div id="id-Mapping">
					<label class="select">
						<select name="id_mapping_kelas" id="id_mapping_kelas">
							<option value="">--Select--</option>																
						</select> <i></i> 
					</label></div>';
					
					$jekel = '<label class="select">
									<select name="jenis_kelamin">
										<option value="">--Select--</option>
										<option value="L">Laki-Laki</option>
										<option value="P">Perempuan</option>									
									</select> <i></i> 
								</label>';
								
					$kelas='<div id="id-MappingKls"><label class="select">
									<select name="kelas" onchange="getWaliKelas(this.value);getType(this.value);" >
									<option value="">--Select--</option></select> <i></i> 
								</label></div>';
					
					$get_smk = $this->ref_siswa->getDataSMK();
					$nama_smk='<label class="select">
									<select name="smk" onchange="getJurusan(this.value), getTypeSPP(this.value), cekKelas(this.value, 0), getWaliKelas(0,0);getType(this.value);" >
									<option value="">--Select--</option>';
					
					foreach ($get_smk as $v_smk) {
						//for($i=0;$i<$temp_i;$i++){
							//if($edit->kelas==$v_smk['name']){
							//	$nama_smk .='<option value="'.$v_smk['name'].'" selected>'.$v_smk['name'].'</option>';
							//}else{
								$nama_smk .='<option value="'.$v_smk['id'].'">'.$v_smk['name'].'</option>';
							//}
						//}
						
					}
					$nama_smk .='</select> <i></i> 
								</label>';
					
					
					$mappingJur = '<div id="id-MappingJur">
					<label class="select">
						<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas(this.value);">
							<option value="">--Select--</option>																
						</select> <i></i> 
					</label></div>';
					
					$mappingTypeSPP = '<div id="id-TypeSPP">
					<label class="select">
						<select name="id_type_spp" id="id_type_spp">
							<option value="">--Select--</option>																
						</select> <i></i> 
					</label></div>';
					
					$status = '<label class="select">
						<select name="status" id="status">
							<option value="">--Select--</option>
							<option value="1">Aktif</option>	
							<option value="0">Tidak Aktif</option>		
							<option value="-1">Lulus</option>															
						</select> <i></i> 
					</label>';
					
					$agama='<label class="select">
									<select name="agama">
									<option value="" selected>--Select--</option>
									<option value="Islam">Islam</option>
									<option value="Kristen Protestan">Kristen Protestan</option>
									<option value="Katolik">Katolik</option>
									<option value="Hindu">Hindu</option>
									<option value="Buddha">Buddha</option>
									<option value="Kong Hu Cu">Kong Hu Cu</option>
									</select> <i></i> 
								</label>';
					
					$mappingType = '<div id="id-MappingType">
					<label class="select">
						<select name="id_mapping_type" id="id_mapping_type" >
							<option value="">--Select--</option>																
						</select> <i></i> 
					</label></div>';
					
					$data['header'] = 'Add Master Siswa';
					$data['submit'] = 'create';
				} else {
					echo $this->gparam['restrict']; die();
				}	
			}
			$data['mappingType'] = $mappingType;
			$data['type_spp'] = $mappingTypeSPP;
			$data['nama_smk'] = $nama_smk;
			$data['mappingJur'] = $mappingJur;
			$data['mapping'] = $mapping;
			$data['kelas'] = $kelas;
			$data['jkel'] = $jekel;
			$data['status'] = $status;
			$data['agama'] = $agama;
			$this->load->view('crud_ref_siswa',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	function getJurusan() {
		$id_smk = $this->input->post("smk");
		$options = $this->ref_siswa->getJurusan($id_smk);
		//untuk SMK
		if($id_smk==1){
			$html = '<label class="select">
							<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas('.$id_smk.', this.value), getWaliKelas(0,0);">
								<option value="">--Select--</option>																
							'.$options.'
							</select> <i></i> 
						</label>';
		}
		//untuk SMA
		else if($id_smk==2){
			$html = '<label class="select">
							<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas('.$id_smk.', this.value);">																
							<option value="4"> - </option>
							</select> <i></i> 
						</label>';
		}
		//untuk SMP
		else if($id_smk==3){
			$html = '<label class="select">
							<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas('.$id_smk.', this.value);">															
							<option value="5"> - </option>
							</select> <i></i> 
						</label>';
		}else{
			$html = '<label class="select">
							<select name="id_mapping_jur" id="id_mapping_jur" onchange="cekKelas('.$id_smk.', this.value);">
								<option value="">--Select--</option>
							</select> <i></i> 
						</label>';
		}
		echo $html;			
	}
	
	function getTypeSPP(){
		$id_smk = $this->input->post("smk");
		$options = $this->ref_siswa->getTypeSPP($id_smk);
	
		$html = '<label class="select">
						<select name="id_type_spp" id="id_type_spp">
							<option value="">--Select--</option>																
						'.$options.'
						</select> <i></i> 
					</label>';
		echo $html;			
	}
	function cekKelas() {
		
		$id_jur = $this->input->post("id_jur");
		$id_smk = $this->input->post("id_smk");
		$options = $this->ref_siswa->cekKelas($id_smk);
		if($id_smk==1){
			$html='<label class="select">
									<select name="kelas" onchange="getWaliKelas(this.value,'.$id_jur.');" >
									<option value="">--Select--</option>'.$options.'</select> <i></i> 
								</label>';
		}else if($id_smk==2){
			$html='<label class="select">
									<select name="kelas" onchange="getWaliKelas(this.value,4);" >
									<option value="">--Select--</option>'.$options.'</select> <i></i> 
								</label>';
		}else if($id_smk==3){
			$html='<label class="select">
									<select name="kelas" onchange="getWaliKelas(this.value,5);" >
									<option value="">--Select--</option>'.$options.'</select> <i></i> 
								</label>';
		}
		
								
		echo $html;			
	}
	
	function getWaliKelas() {
		$kelas = $this->input->post("kelas");
		$id_mapping_jur = $this->input->post("id_mapping_jur");
		
		$options = $this->ref_siswa->getWaliKelas($kelas, $id_mapping_jur);
	
		$html = '<label class="select">
						<select name="id_mapping_kelas" id="id_mapping_kelas">
							<option value="">--Select--</option>																
						'.$options.'
						</select> <i></i> 
					</label>';
		echo $html;			
	}
	
	function getType() {
		
		$id_smk = $this->input->post("id_smk");
		
		$options = $this->ref_siswa->cekType($id_smk);
		$html='<label class="select">
									<select name="id_mapping_type" >
									<option value="">--Select--</option>'.$options.'</select> <i></i> 
								</label>';
								
		echo $html;			
	}
	
	public function crud() {
		
		$crud = $this->input->post('submit');
		if ($crud == 'create') {
			
			$insert = $this->ref_siswa->insert_data();
			if ($insert) {
				$json = true;
			}
			
		} else if ($crud == 'update') {
			$update = $this->ref_siswa->update_data();
			if ($update) {
				$json = true;			
			}
				
		}
		
		echo json_encode($json);
		
	}
	
	function cek_nisn() {
		$id_siswa 	= $this->input->post("id_siswa");
		$nisn 		= $this->input->post("nisn");
		
		if ($id_siswa == "") {
			$cek = $this->ref_siswa->cekNisn($nisn);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		} else {
			$cek = $this->ref_siswa->cekNisnUpdate($nisn,$id_siswa);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		}
		
		echo json_encode($json);	
		
	}
	
	function cek_nis() {
		
		$id_siswa 	= $this->input->post("id_siswa");
		$nis 		= $this->input->post("nis");
		
		if ($id_siswa == "") {
			$cek = $this->ref_siswa->cekNis($nis);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		} else {
			$cek = $this->ref_siswa->cekNisUpdate($nis,$id_siswa);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		}
		
		echo json_encode($json);	
		
	}
	
	function get_fancy_image() {
		header('Content-Type: application/json'); // parsing json
        $list = $this->ref_siswa->get_fancy();
        echo json_encode($list);
	}
	
	function load_data() {
		header('Content-Type: application/jsonp');
        $list = $this->ref_siswa->get_list_data();
		
        echo json_encode($list);
	}
	
	
}
