<!-- Widget ID (each widget will need unique ID)-->
<div class="jarviswidget" id="wid-id-6" data-widget-editbutton="false" data-widget-custombutton="false" data-widget-deletebutton="false">
	<!-- widget options:
		usage: <div class="jarviswidget" id="wid-id-0" data-widget-editbutton="false">
		
		data-widget-colorbutton="false"	
		data-widget-editbutton="false"
		data-widget-togglebutton="false"
		data-widget-deletebutton="false"
		data-widget-fullscreenbutton="false"
		data-widget-custombutton="false"
		data-widget-collapsed="true" 
		data-widget-sortable="false"
		
	-->
	<header>
		<span class="widget-icon"> <i class="fa fa-edit"></i> </span>
		<h2>Transaksi PPDB</h2>				
		
	</header>

	<!-- widget div-->
	<div>
		
		<!-- widget edit box -->
		<div class="jarviswidget-editbox">
			<!-- This area used as dropdown edit box -->
			
		</div>
		<!-- end widget edit box -->
		
		<!-- widget content -->
		<div class="widget-body no-padding">
			
			<form action="<?php echo @$action; ?>" method="post" id="crud-form" class="smart-form">
				<header>
					<?php echo $header; ?>
				</header>

				<fieldset>
					<div class="row">
						<section class="col col-5">
							<label class="label">Nama Siswa</label>
							<label class="select">
								<select name="id_siswa" id="id_siswa" onchange="getCicilan(this.value)" class="chosen-select">
									<?php echo $siswa; ?>								
								</select>
								<i></i>
							</label>
						</section>
						
						
					</div>
                    <div class="row">
                   		<section class="col col-2">
							<label class="label">Cicilan Pembayaran</label>
							<?php echo $cicilan; ?>
						</section>
                    </div>
					
					<div class="row">
						<section class="col col-2">
							<label class="label">Tanggal Transaksi</label>							
								<label class="input"> 
									<input id="tanggal_pembayaran" type="text" name="tanggal_pembayaran"  value="<?php echo @$t_trans; ?>" />									
								</label>								
						</section>		
						
						<section class="col col-3">
							<label class="label">Nomor Transaksi</label>
							<label class="input"> 
									<input id="last_id" type="hidden" name="last_id"  value="<?php echo $last_id; ?>"/>									
									<?php echo @$faktur; ?>									
							</label>
						</section>
					</div>
					<div class="row">
						
						<div id="id-cicilan">
							
							<section class="col col-2">
								<label class="label">Sisa Cicilan</label>							
								<label class="input"> 
									<input id="sisa" type="text" name="sisa"  value="0" readonly="readonly" />									
								</label>								
							</section>
							
							<section class="col col-2">
								<label class="label">Total Cicilan</label>							
								<label class="input"> 
									<input id="total" type="text" name="total"  value="0" readonly="readonly" />									
								</label>								
							</section>
							
						</div>
						
						<section class="col col-2">
							<label class="label">Besar Pembayaran</label>							
								<label class="input"> 
									<input id="besarnya" type="text" name="besarnya"  value="<?php echo @$besarnya; ?>" />									
								</label>								
						</section>
						
					</div>
				</fieldset>
					
				
				<footer>
					<button type="submit" name="submit" class="btn btn-primary" value="<?php echo $submit; ?>">
						Save
					</button>
					<button type="reset" id="cancel_create" name="cancel" class="btn btn-default" >
						Batal
					</button>
				</footer>

				<div class="message">
					<i class="fa fa-check fa-lg"></i>
					<p>
						Your comment was successfully added!
					</p>
				</div>
			</form>
			
		</div>
		<!-- end widget content -->
		
	</div>
	<!-- end widget div -->
				
</div>
<!-- end widget -->

<script type="text/javascript">
	getCicilan
	
	function getCicilan(idSiswa) {
		$.ajax({
			type:"POST",
			dataType: "html",
			url:"<?php echo site_url("/") . $controller . "/getCicilan"; ?>",
			data : "idSiswa="+idSiswa,
			success:function(msg){
				$("#id-MappingCicilan").html(msg);							
			},
			error:function(){
				alert("Load failed");
			}
		});
	}
	
	function getDetailCicilan(idSiswa, cicilan) {
		$.ajax({
			type:"POST",
			dataType: "html",
			url:"<?php echo site_url("/") . $controller . "/getDetailCicilan"; ?>",
			data : "idSiswa="+idSiswa+"&&cicilan="+cicilan,
			success:function(msg){
				$("#id-cicilan").html(msg);							
			},
			error:function(){
				alert("Load failed");
			}
		});
	}
		
	$(function() {
			
		$(".chosen-select").chosen();
		
		$('#tanggal_pembayaran').datetimepicker({
			format: 'DD-MM-YYYY'
		});
		
		alert_cancel = 'Are You Sure to cancel this form ?';
		$('#cancel_create').on('click', function () {
			if (confirm(alert_cancel)) {
				window.location.href = "<?php echo site_url('/').'home#'.$controller; ?>";
			}
		});
		
		jQuery.validator.addMethod("besarPembayaran", function(value, element){
			
			var sisa = 0;
			var inputVal; 			
			sisa = parseInt($("#sisa").val());
			inputVal = parseInt(value);
			if (sisa == 0) {
				return false;
				
			} else {
				if (inputVal > sisa) {
					return false;
				} else {
					return true;
				}
			}			
		}, "Pembayaran Melebihi Cicilan"); 
		
		
		// Validation
		$("#crud-form").validate({
			// Rules for form validation
			rules : {
				tanggal_pembayaran : {
					required : true						
				},
				id_siswa : {
					required : true
				},
				besarnya : {
					required : true,
					number : true,
					besarPembayaran : true
				}
			},
			ignore: [],
			submitHandler : function(form) {
				
				$(form).ajaxSubmit({
					
					dataType: 'json',
					success : function(msg) {
						window.location.hash = base_url + 'index.php/<?php echo $controller; ?>/successPage';
						
					}
				});
				
			},

			// Messages for form validation
			messages : {
				tanggal_pembayaran : {
					required : 'Tanggal Pembayaran Harus di isi'						
				},
				id_siswa : {
					required : 'Pilih Siswa'
				},
				besarnya : {
					required : 'Masukan Besar Pembayaran',
					number : 'Besar Pembayaran Harus Angka'
				}
				
						},

			// Do not change code below
			errorPlacement : function(error, element) {
				error.insertAfter(element.parent());
			}
		});		
		
	});
</script>