<?php 
class Adm_tahun_ajaran_model extends CI_Model {
	
	function get_list_data() {
	
		$param = $this->input->post(array('page', 'rows', 'sort', 'order', 'filterRules'));
        $offset = intval(($param['page'] - 1) * $param['rows']);
		
		// clause filter, array not null
        $cond = '';
        if (count($param['filterRules']) > 0) {
            $filter = json_decode($param['filterRules']);
            $loop = 0;
            foreach ($filter as $json) {
                // convert to array
                $rule = get_object_vars($json);
                // declare variable
                $field = $rule['field'];
                $opt = $rule['op'];
                $value = $rule['value'];
                if ($loop == 0) {
                    // user where
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= "where ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= "where $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= "where $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= "where $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= "where $field = '$value'";
                        }
                        $loop++; // flag where
                    }
                } else {
                    // user and
                    if (!empty($value)) {
                        if ($opt == 'contains') {
                            $cond .= " and ($field like '%$value%')";
                        } else if ($opt == 'greater') {
                            $cond .= " and $field > '$value'";
                        } else if ($opt == 'less') {
                            $cond .= " and $field < '$value'";
                        } else if ($opt == 'notequal') {
                            $cond .= " and $field != '$value'";
                        } else if ($opt == 'equal') {
                            $cond .= " and $field = '$value'";
                        }
                    }
                }
            }
        }
		
		$response = array();
		$table = 'ref_tahun_ajaran'; 
		 
        if (empty($param['sort'])) {
            if (empty($cond)) {
                $sql = "select row_id, tahun_ajaran, status, keterangan, created_by, created_date, modified_by, modified_date from $table where sts_ppdb=0 order by created_date limit ?, ?";
                $sqlcount = "select * from $table where sts_ppdb=0";
            } else {
                $sql = "select row_id, tahun_ajaran, status, keterangan, created_by, created_date, modified_by, modified_date from $table  $cond and sts_ppdb=0 order by created_date limit ?, ?";
                $sqlcount = "select * from $table $cond and sts_ppdb=0";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        } else {
            $sort = $param['sort'];
            $order = $param['order'];
            if (empty($cond)) {
                $sql = "select row_id, tahun_ajaran, status, keterangan, created_by, created_date, modified_by, modified_date from $table where sts_ppdb=0 order by $sort $order limit ?, ?";
                $sqlcount = "select row_id from $table where sts_ppdb=0";
            } else {
                $sql = "select row_id, tahun_ajaran, status, keterangan, created_by, created_date, modified_by, modified_date from $table  $cond and sts_ppdb=0 order by $sort $order limit ?, ?";
                $sqlcount = "select row_id from $table  $cond and sts_ppdb=0";
            }
            $result_array = $this->db->query($sql, array($offset, intval($param['rows'])));
            $response['total'] = $this->db->query($sqlcount)->num_rows();
            $response['rows'] = $result_array->result();
        }
        return $response;
	}
	
	function change_tahun_ajaran($row_id) {
		
		//update status to N
		/* $this->db->set("status","'N'",false);
		$this->db->where("status","U");
		$update = $this->db->update("ref_tahun_ajaran");
		 */
		 
		$update = $this->update_tahun_ajaran();
		
		if ($update) {
			$this->db->set("status","'U'",false);
			$this->db->where("row_id",$row_id);
			$update = $this->db->update("ref_tahun_ajaran");
			
			
			$this->db->select('*');
			$this->db->from("ref_siswa");
			$this->db->where('kelas <=', 13);
			$num = $this->db->get()->result_array();
			
		/*
			foreach ($num as $v_sis) {
				
				$id_mapping_kelas = $v_sis['id_mapping_kelas'];
				$id_siswa = $v_sis['id_siswa'];
				$kelas = $v_sis['kelas'];
				if($kelas<12){
					$kelas = $kelas+1;
				}else{
					$kelas = 13;
				}
				
				$ruang_kls = $this->get_ruang_kelas($id_mapping_kelas);
				
				$id_smk = $v_sis['id_smk'];
				$id_jur = $v_sis['id_jur'];
				
				$wali_kelas = $this->get_wali_kelas($id_smk, $id_jur, $kelas, $ruang_kls->ruang_kelas);
			
				$mapping_kelas = $this->get_mapping_kelas($id_smk, $id_jur, $kelas, $ruang_kls->ruang_kelas, $wali_kelas->id_karyawan);
				
				
				$this->db->set("kelas",$kelas);
				$this->db->set("id_wali_kelas", $wali_kelas->id_karyawan);
				$this->db->set("id_mapping_kelas",$mapping_kelas->id);
				$this->db->where("id_siswa",$id_siswa);
				//$q = $this->db->update("ref_siswa");
				
				if ($q) {
					$this->insertRepSpp($id_siswa);
				}
				
			}
			*/
		}
		 
		return $update;
	}
	
	function insertRepSpp($id) {
		
		//get tahun ajaran
		$thn = $this->get_tahun_ajaran();
		//get data siswa
		$this->db->select("nis,id_siswa");
		$this->db->from("ref_siswa");
		$this->db->where("id_siswa",$id);
		$q = $this->db->get()->row();
		
		//print_r($q); die();
		$nis = $q->nis;
		$id_siswa = $q->id_siswa;
		
		//cek 
		$this->db->select("id");
		$this->db->from("rep_spp");
		$this->db->where(
			array(
				"tahun_ajaran" => $thn,
				"nis"		   => $nis,
				"id_siswa"	   => $id_siswa	
			)
		);
		$num = $this->db->get()->num_rows();
		
		if ($num == 0) {
			$data = array(
				"tahun_ajaran" => $thn,
				"nis" 		=> $nis,
				"id_siswa"  => $id_siswa
			);
			$q = $this->db->insert("rep_spp",$data);
		}
		 
		//return true;
		
	}
	function get_tahun_ajaran() {
		
		$this->db->select("tahun_ajaran");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("status","U");
		$this->db->where("sts_ppdb",0);
		$data = $this->db->get()->row()->tahun_ajaran;
		return $data;
		
	}
	
	function get_ruang_kelas($id_mapping_kelas){
		$this->db->select("ruang_kelas");
		$this->db->from("ref_mapping_kelas");
		$data = $this->db->get()->row();
		return $data;
	}
	
	function get_wali_kelas($id_smk, $id_jur, $kelas, $ruang_kelas){
		$this->db->select("id_karyawan");
		$this->db->from("ref_mapping_kelas");
		$this->db->where("id_smk",$id_smk);
		$this->db->where("id_jur",$id_jur);
		$this->db->where("kelas",$kelas);
		$this->db->where("ruang_kelas",$ruang_kelas);
		$wali_kelas = $this->db->get()->row();
		return $wali_kelas;
	}
	
	function get_mapping_kelas($id_smk, $id_jur, $kelas, $ruang_kelas, $wali_kelas){
		$this->db->select("id");
		$this->db->from("ref_mapping_kelas");
		$this->db->where("id_smk",$id_smk);
		$this->db->where("id_jur",$id_jur);
		$this->db->where("kelas",$kelas);
		$this->db->where("ruang_kelas",$ruang_kelas);
		$this->db->where("id_karyawan",$wali_kelas);
		$id_mapping_kelas = $this->db->get()->row();
		return $id_mapping_kelas;
	}
	
	function update_tahun_ajaran() {
		
		$this->db->set("status","'N'",false);
		$this->db->where("status","U");
		$this->db->where("sts_ppdb",0);
		$update = $this->db->update("ref_tahun_ajaran");
		
		return $update; 
	}
	
	function cek_tahun_ajaran($tahun_ajaran) {
		
		$this->db->select("row_id");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("tahun_ajaran",$tahun_ajaran);
		$this->db->where("sts_ppdb",0);
		$num = $this->db->get()->num_rows();
		
		return $num;
		
	}
	
	function insert_data($data) {
		
		$status = $data['status'];
		
		if ($status == "U") {
			$update = $this->update_tahun_ajaran();
		}
		
		$q = $this->db->insert("ref_tahun_ajaran",$data);
		if (!$q) {
			echo $this->db->_error_message(); die();
		}
		
		return true;
	
	}
	
}