<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ref_jabatan extends CI_Controller {
	
	var $gparam = array();
	
	public function __construct() {
        parent::__construct();
		$this->gparam['controller'] = $this->router->fetch_class();
		$this->load->model('ref_jabatan_model', 'ref_jabatan');
		$this->gparam['privilage'] = getPrivilage($this->gparam['controller']);
		$this->gparam['restrict'] = 'You Cannot Access This Menu';
    }
	
	public function index()
	{
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			
			$gridopt = $this->input->get(array('psize', 'pnumber'));
			header('Content-Type: text/html');
			
			$create_button = '""';			
			$update_button = '';
			$delete_button = '';		
			
			if ($this->gparam['privilage']->privilage_create == 'Y') {
				//create button
				$create_button = '<a href="javascript:void(0)"  class="btn btn-primary btn-xs" onclick="create_view();" >
									<i class="fa fa-lg fa-fw fa-plus"></i>Create
								  </a>';
			}	
			
			if ($this->gparam['privilage']->privilage_update == 'Y') {
				$update_button = "<a style=\"margin:4px;\" class=\"btn btn-success btn-xs\" onclick=\"edit_view('+row.id+')\" href=\"javascript:void(0)\"\
									group=\"\" data-toggle=\"tooltip\" title=\"Update\"><i class=\"fa fa-lg fa-fw fa-edit\"></i>\
								  </a>";
			}

			if ($this->gparam['privilage']->privilage_delete == 'Y') {	
				$delete_button = "<a style=\"margin:4px;\" class=\"btn btn-danger btn-xs\" onclick=\"delete_data('+row.id+')\" href=\"javascript:void(0)\" group=\"\" data-toggle=\"tooltip\" title=\"Delete\">\
									<i class=\"fa fa-lg fa-fw fa-trash-o\"></i>\
								</a>"; 
			}		

			
			
			// pnumber, psize
			$data = array(
					'controller'  			=> $this->gparam['controller'],
					'psize'  				=> (empty($gridopt['psize'])?10:$gridopt['psize']),
					'pnumber'  				=> (empty($gridopt['pnumber'])?1:$gridopt['pnumber']),
					'create' 				=> $create_button,
					'update' 				=> $update_button,
					'delete'				=> $delete_button
			);
			
			$this->load->view('ref_jabatan_view',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}
	
	function form() {
		
		if ($this->gparam['privilage']->privilage_view == 'Y') {
			$data['controller'] = $this->gparam['controller'];				
			$data['action'] = base_url()."index.php/".$this->gparam['controller']."/crud";
			$id = $this->uri->segment(3);	
			
			if (!empty($id)) {
				if ($this->gparam['privilage']->privilage_update == 'Y') {				
					//get value for edit
					$edit = $this->ref_jabatan->get_value_edit($id);
					
					$data['jabatan'] 		= $edit->jabatan;
					$data['keterangan'] 	= $edit->keterangan;					
					$data['id'] 			= $id;
					$data['header'] 		= 'Edit Jabatan';
					$data['submit'] 		= 'update';	
				} else {
					echo $this->gparam['restrict']; die();
				}	
			} else {
				if ($this->gparam['privilage']->privilage_create == 'Y') {	
					
					$data['header'] = 'Add Jabatan';
					$data['submit'] = 'create';
				} else {
					echo $this->gparam['restrict']; die();
				}	
			}
			
			
			$this->load->view('crud_ref_jabatan',$data);
		} else {
			echo $this->gparam['restrict'];
		}
	}	
	
	
	public function crud() {
		
		$crud = $this->input->post('submit');
		if ($crud == 'create') {
			
			$insert = $this->ref_jabatan->insert_data();
			if ($insert) {
				$json = true;
			}
			
		} else if ($crud == 'update') {
			$update = $this->ref_jabatan->update_data();
			if ($update) {
				$json = true;			
			}
				
		}
		
		echo json_encode($json);
		
	}
	
	public function delete() {
		
		$delete = $this->ref_jabatan->delete_data();
		if ($delete) {
			$json = true;
		}
		echo json_encode($json);	
	}
	
	
	function cek_jabatan() {
		
		$id = "";
		$jabatan 		= $this->input->post('jabatan');
		$id 			= $this->input->post('id');
		
		//echo $role."--".$id; die(); 
		if ($id == "") {
			$cek = $this->ref_jabatan->cekJabatan($jabatan);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		} else {
			$cek = $this->ref_jabatan->cekJabatanUpdate($jabatan,$id);			
			if ($cek > 0) {
				$json = false;
			} else {
				$json = true;
			}
		}
		
		echo json_encode($json);		
	}
	
	function load_data() {
		
		header('Content-Type: application/jsonp');
        $list = $this->ref_jabatan->get_list_data();
		
        echo json_encode($list);
	}
	
	
}
