<!-- EasyUI CSS -->
<link href="<?php echo base_url() . "assets/" ?>easyui/themes/bootstrap/easyui.css" rel="stylesheet">
<link href="<?php echo base_url() . "assets/" ?>easyui/themes/icon.css" rel="stylesheet">

	<div class="row">
		<div class="col-lg-12">
			<!-- header -->
			<h3 class="cpage-header">PPDB - Edit Komponen Biaya</h3>
			<?php // echo $output; ?>
		</div>
	</div>

	<div class="row">
		<div id="table-content" class="col-lg-12">
			<table id="tbl">

			</table>
		</div>
	</div>

	<div class="row">
		<div class="extra-footer col-lg-12" style="height:25px;"></div>
		<div class="col-lg-12 page-footer-table"></div>
		<!-- only space 
		-->
	</div>

<script>

	var tbl, setup; // setup is flag
    $(document).ready(function () {
		setup = 0;
		tbl = $('#tbl').datagrid({width: '100%'});
        // toolbar action
		var toolbar = <?php echo $create; ?>;
		
		// handle when direct update or create
		tbl.datagrid({
			pageNumber: '<?php echo $pnumber?>',
			pageSize: '<?php echo $psize?>',
		});
        tbl.datagrid({
            url: '<?php echo site_url('/') . $controller . '/load_data'; ?>',
            title: "List PPDB Siswa",
            toolbar: toolbar,
            singleSelect: true,
            resizable: true,
            collapsible: true,
            fitColumn: true,
            rownumbers: true,
            pagination: true,
            nowrap: false,
            remoteFilter: true,
            onLoadSuccess: loadAction, // event on navigator.js
            //onAfterRender: tableAfterLoad,
            /*
             filterStringify: function(data){
             $.map(data, function(item){
             if (item.field == 'changeDate'){
             item.value = $.fn.datebox.defaults.parser(item.value).getTime();
             }
             });
             return JSON.stringify(data);
             },
             */
			frozenColumns:[[
				{field: 'options', title: 'ACTION', width: 120, halign: 'center', align: 'center', formatter: formatButton},
				{field: 'nama', title: 'Nama Calon Siswa', width: 200, sortable: 'true', halign: 'center', align: 'center'},
				{field: 'nisn', title: 'NISN', width: 130, sortable: 'true', halign: 'center', align: 'center'},
				{field: 'smk', title: 'SMK', width: 120, sortable: 'true', halign: 'center', align: 'center'},
				
				
			]],	
            columns: [[  
			{field: 'tahun_ajaran', title: 'Tahun Ajaran', width: 120, sortable: 'true', halign: 'center', align: 'center'},
				{field: 'no_type', title: 'DSP', width: 100, sortable: 'true', halign: 'center', align: 'center',formatter: formatType},
					//{field: 'agama', title: 'Agama', width: 120, sortable: 'true', halign: 'center', align: 'center'},           
					{field: 'asal_sekolah', title: 'Asal Sekolah', width: 120, sortable: 'true', halign: 'center', align: 'center'},                  
                    //{field: 'tempat_lahir', title: 'Tempat Lahir', width: 120, sortable: 'true', halign: 'center', align: 'center'},
                   // {field: 'tanggal_lahir', title: 'Tanggal Lahir', width: 120, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'jenis_kelamin', title: 'Jenis Kelamin', width: 170, sortable: 'true', halign: 'center', align: 'center',formatter: formatJekel},
                  //  {field: 'nama_ayah', title: 'Nama Ayah', width: 170, sortable: 'true', halign: 'center', align: 'center'},
                   // {field: 'nama_ibu', title: 'Nama Ibu', width: 170, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'alamat', title: 'Alamat', width: 300, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'telepon', title: 'Telepon', width: 100, sortable: 'true', halign: 'center', align: 'center'},
                    //{field: 'tahun_ajaran', title: 'Tahun Ajaran', width: 100, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'created_by', title: 'Created By', width: 100, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'created_date', title: 'Created Date', width: 150, sortable: 'true', halign: 'center'},
                    {field: 'modified_by', title: 'Modified By', width: 100, sortable: 'true', halign: 'center', align: 'center'},
                    {field: 'modified_date', title: 'Modified Date', width: 150, sortable: 'true', halign: 'center'},
                    
                ]]
        });
    });
	
	function loadAction() {
		// fix asyn setup and multiple setup
		if (setup == 0){
			tbl.datagrid('enableFilter',
				 [ {
					field: 'created_date',
					type: 'datebox',
					options: {formatter: myFormatter, parser: myParser},
					op: ['equal', 'less', 'greater']
				},{
					field: 'modified_date',
					type: 'datebox',
					options: {formatter: myFormatter, parser: myParser},
					op: ['equal', 'less', 'greater']
				},{
					field: 'tanggal_lahir',
					type: 'datebox',
					options: {formatter: myFormatter, parser: myParser},
					op: ['equal', 'less', 'greater']
				}] 
			);  
			// remove filter option
			$("input[name='options']").remove();
			setup = 1;
		}
		// fix
		//resizeContentDOMFit();
		// filter
		tbl.datagrid('resize', 'fixRowHeight');
	}
	
	 // format date
    function myFormatter(date) {
        var y = date.getFullYear();
        var m = date.getMonth() + 1;
        var d = date.getDate();
        return y + '-' + (m < 10 ? ('0' + m) : m) + '-' + (d < 10 ? ('0' + d) : d);
    }

    // required
    function myParser(s) {
        if (!s)
            return new Date();
        var ss = (s.split('-'));
        var y = parseInt(ss[0], 10);
        var m = parseInt(ss[1], 10);
        var d = parseInt(ss[2], 10);
        if (!isNaN(y) && !isNaN(m) && !isNaN(d)) {
            return new Date(y, m - 1, d);
        } else {
            return new Date();
        }
    }

	
	 // inline editor on row
    //load edit view	
	function edit_view(id_daftar) {
		window.location.href = "<?php echo '#'.$controller.'/form/'; ?>"+id_daftar;
	}
	
	function delete_data(id_daftar) {
		
		var alertmsg = 'Delete Data Ini ?';
		if (confirm(alertmsg)) {
			
			
			/* $.post("adm_tahun_ajaran/change_tahun_ajaran", {row_id: row_id}, function () {
                  //window.location.href = '#adm_tahun_ajaran/';
                    //window.location.reload();
                }, 'json'); */
				
			$.ajax({
			url:"<?php echo site_url('/').$controller; ?>/delete",
			type: "POST",
			dataType:"json",
			data:"id_daftar="+id_daftar,
			success : function(msg){			
				container = $('#content');
				var url = location.hash.replace(/^#/, '');
				loadURL(url + location.search, container);
			},
			error :function(msg){
				$("#content").html("<span class='label label-important'> Error </span>");			
				$("#loading_anim").hide();
			}
			}); 
			
		}
	}
	
	function preview_image(id) {
		 $.ajax({
            url: '<?php echo site_url('/') . $controller . "/get_fancy_image"; ?>',
            type: 'POST',
            async: false,
            data: {id_daftar: id},
            dataType: 'json',
            success: function (result) {
                // var p = result.images;
                var tempFile = [];
                $.each(result.images, function (index, value) {
                    var tempFileElemet = {href: '<?php echo base_url() . DIR_SISWA; ?>' + value.image_name, title: value.image_name};
                    tempFile.push(tempFileElemet);
                });
               
                
				$.fancybox.open(tempFile, {
                    helpers: {
                        thumbs: {
                            width: 75,
                            height: 50
                        }
                    }
                });
            }
        });
	}
	
	function approve_data(id_daftar) {
		
		var alertmsg = 'Approve Siswa ?';
		if (confirm(alertmsg)) {
			
			
			/* $.post("adm_tahun_ajaran/change_tahun_ajaran", {row_id: row_id}, function () {
                  //window.location.href = '#adm_tahun_ajaran/';
                    //window.location.reload();
                }, 'json'); */
				
			$.ajax({
			url:"<?php echo site_url('/').$controller; ?>/approve_data",
			type: "POST",
			dataType:"json",
			data:"id_daftar="+id_daftar,
			success : function(msg){			
				container = $('#content');
				var url = location.hash.replace(/^#/, '');
				loadURL(url + location.search, container);
			},
			error :function(msg){
				$("#content").html("<span class='label label-important'> Error </span>");			
				$("#loading_anim").hide();
			}
			}); 
			
		}
	}
	
	function reject_data(id_daftar) {
		
		var alertmsg = 'Reject Pendaftaran ?';
		if (confirm(alertmsg)) {
			
			
			/* $.post("adm_tahun_ajaran/change_tahun_ajaran", {row_id: row_id}, function () {
                  //window.location.href = '#adm_tahun_ajaran/';
                    //window.location.reload();
                }, 'json'); */
				
			$.ajax({
			url:"<?php echo site_url('/').$controller; ?>/reject_data",
			type: "POST",
			dataType:"json",
			data:"id_daftar="+id_daftar,
			success : function(msg){			
				container = $('#content');
				var url = location.hash.replace(/^#/, '');
				loadURL(url + location.search, container);
			},
			error :function(msg){
				$("#content").html("<span class='label label-important'> Error </span>");			
				$("#loading_anim").hide();
			}
			}); 
			
		}
	}
	
	function formatJekel(val, row, index) {
		if (row.jenis_kelamin == 'L') {
			return 'Laki-Laki';
		} else {
			return 'Perempuan';	
		}
	}
	
	function formatType(val, row, index) {
		if (row.no_type == 3) {
			return 'Lanjutan';
		} else{
			return 'Gel. '+row.no_type;
		}
	}
	
	// inline editor on row
    function formatButton(val, row, index) {
      
		var app_stat 	= row.approval_status;	  
		
		var preview 	= '<?php echo @$image_button; ?>';
		var updateBtn 	= '<?php echo @$update; ?>';	
		
		var appBtn = '';
		var rjbtn = '';
		if (app_stat == 2) {
			var deleteBtn = '<?php echo @$delete; ?>';
		} else {
			if ((app_stat == 0)||(app_stat == 1)) {
				appBtn = '<?php echo @$approval_button; ?>';
				rjbtn = '<?php echo @$reject_button; ?>';
			} 
			var deleteBtn = '';
		}
		
        
		var scpace = '&nbsp;&nbsp;&nbsp;';
        // return previewBtn
        //return updateBtn + scpace + deleteBtn + appBtn + scpace + rjbtn;
		return updateBtn ;
		
    }	
</script>