<?php 
class Rep_penerimaan_harian_model extends CI_Model {
	
	function get_header($id_smk) {
		
		$tahun_ajaran = $this->get_tahun_ajaran();
		//get ref transaksi
		$q = $this->db->query("SELECT kodedesk, kodesub, daftarlist FROM ref_list_uang_masuk where Id IN (SELECT DISTINCT(id_coa) as Id from ref_list_biaya) order by Id asc");
		/*
		if($id_smk=='' || empty($id_smk)){
			$q = $this->db->query("SELECT kodedesk, kodesub FROM ref_list_uang_masuk WHERE order by Id asc");
		}else{
			$q = $this->db->query("SELECT a.jenispembayaran, a.id_smk, a.kelas, a.id, b.kodedesk, b.kodesub FROM ref_list_biaya a, ref_list_uang_masuk b WHERE a.id_coa=b.Id and a.id_smk='".$id_smk."' order by a.id_smk asc, a.kelas asc");
			
			$this->db->select("a.jenispembayaran, a.id_smk, a.kelas, a.id, b.kodedesk, b.kodesub");
			$this->db->from("ref_list_biaya a, ref_list_uang_masuk b");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->where("a.id_smk",$id_smk);
			$this->db->where("a.id_coa","b.Id");
			$this->db->order_by("a.id_smk","asc");
			$this->db->order_by("a.kelas","asc");
			
		}
		*/
		$data = $q->result_array();
		return $data;
		
	}
	
	function get_count_header($id_smk) {
		
		$tahun_ajaran = $this->get_tahun_ajaran();
		//get ref transaksi
		if(($id_smk=='') || (empty($id_smk))){
			$this->db->select("id_smk, count(distinct jenispembayaran) as jenis_pem");
			$this->db->from("ref_list_biaya");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->group_by('id_smk');
			$this->db->order_by("id_smk","asc");
		}else{
			$this->db->select("id_smk, count(distinct jenispembayaran) as jenis_pem");
			$this->db->from("ref_list_biaya");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->where("id_smk",$id_smk);
			$this->db->group_by('id_smk');
			$this->db->order_by("id_smk","asc");
		}
		
		$data = $this->db->get()->result_array();
		return $data;
		
	}
	
	function get_nis($id_siswa){
		$this->db->select("nis");
		$this->db->from("ref_siswa");
		//$this->db->where("tahun_ajaran",$tahun_ajaran);
		$this->db->where("id_siswa",$id_siswa);
		return $this->db->get()->row()->nis;
	}
	
	function get_header_cicilan() {
		
		$q = $this->db->query("SELECT DISTINCT(a.Id), a.kodedesk, a.kodesub, a.daftarlist FROM ref_list_uang_masuk a, ref_komponen_cicilan b WHERE a.Id=b.id_coa");
		$data = $q->result_array();	;
		return $data;
		
	}
	
	function get_cicilan_count_header() {
		
		$q = $this->db->query("SELECT count(DISTINCT(a.Id)) as jum_cicilan FROM ref_list_uang_masuk a, ref_komponen_cicilan b WHERE a.Id=b.id_coa");
		$data = $q->row();	;
		return $data;
		
	}
	
	
	function get_count_header_cicilan($id_smk) {
		
		$tahun_ajaran = $this->get_tahun_ajaran();
		//get ref transaksi
		if(($id_smk=='') || (empty($id_smk))){
			$this->db->select("count(distinct jenis_pembayaran) as jenis_pem, id_smk, no_type");
			$this->db->from("ref_komponen_cicilan");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->group_by('id_smk');
			$this->db->group_by('no_type');
			$this->db->order_by("id_smk","asc");
		}else{
			$this->db->select("count(distinct jenis_pembayaran) as jenis_pem, id_smk, no_type");
			$this->db->from("ref_komponen_cicilan");
			//$this->db->where("tahun_ajaran",$tahun_ajaran);
			$this->db->where("id_smk",$id_smk);
			$this->db->group_by('id_smk');
			$this->db->group_by('no_type');
			$this->db->order_by("id_smk","asc");
		}
		
		$data = $this->db->get()->result_array();
		return $data;
		
	}
	
	
	function get_tahun_ajaran() {
		$this->db->select("tahun_ajaran");
		$this->db->from("ref_tahun_ajaran");
		$this->db->where("status","U");
		$data = $this->db->get()->row()->tahun_ajaran;
		return $data;
	}
	
	function get_id_siswa($periode, $smk) {
		if($smk==''){
			$q = $this->db->query("
				select DISTINCT a.id_siswa, a.sts_ppdb, DATE_FORMAT(a.tanggal_pembayaran,'%d/%m/%Y') as tanggal_pembayaran, a.no_faktur from ( 
					SELECT id_siswa, sts_ppdb, tanggal_pembayaran, no_faktur from trans_siswa where tanggal_pembayaran = '".$periode."'
					UNION ALL 
					SELECT id_siswa, sts_ppdb, tanggal_transaksi as tanggal_pembayaran, no_faktur from trans_spp where tanggal_transaksi = '".$periode."' 
					
					UNION ALL 
					SELECT id_siswa, sts_ppdb, tanggal_transaksi as tanggal_pembayaran, no_faktur from trans_tabsis where tanggal_transaksi = '".$periode."' and SUBSTRING(no_faktur, 1, 2)='FK'
				) a order by no_faktur");
		}else{
			$q = $this->db->query("select DISTINCT a.id_siswa, a.sts_ppdb, DATE_FORMAT(a.tanggal_pembayaran,'%d/%m/%Y') as tanggal_pembayaran, a.no_faktur from ( 
				SELECT a.id_siswa, a.sts_ppdb, a.tanggal_pembayaran, a.no_faktur from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, a.tanggal_transaksi as tanggal_pembayaran, a.no_faktur from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, a.tanggal_transaksi as tanggal_pembayaran, a.no_faktur from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0  and SUBSTRING(no_faktur, 1, 2)='FK'
				UNION ALL
				SELECT a.id_siswa, a.sts_ppdb, a.tanggal_pembayaran, a.no_faktur from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, a.tanggal_transaksi as tanggal_pembayaran, a.no_faktur from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, a.tanggal_transaksi as tanggal_pembayaran, a.no_faktur from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1 and SUBSTRING(no_faktur, 1, 2)='FK'
			) a order by no_faktur");
		}
		
		return $q->result_array();	
	}
	
	/*
	function get_id_siswa($periode, $smk) {
		if($smk==''){
			$q = $this->db->query("
				select DISTINCT a.id_siswa, a.sts_ppdb, a.cicilan from ( 
					SELECT id_siswa, sts_ppdb, cicilan from trans_siswa where tanggal_pembayaran = '".$periode."'
					UNION ALL 
					SELECT id_siswa, sts_ppdb, '0' as cicilan from trans_spp where tanggal_transaksi = '".$periode."' 
				) a");
		}else{
			$q = $this->db->query("select DISTINCT a.id_siswa, a.sts_ppdb, a.cicilan from ( 
				SELECT a.id_siswa, a.sts_ppdb, a.cicilan from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, '0' as cicilan from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=0
				UNION ALL
				SELECT a.id_siswa, a.sts_ppdb, a.cicilan from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_pembayaran = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
				UNION ALL 
				SELECT a.id_siswa, a.sts_ppdb, '0' as cicilan from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and tanggal_transaksi = '".$periode."' and b.id_smk='".$smk."' and a.sts_ppdb=1
			) a");
		}
		
		return $q->result_array();	
	}
	
	*/
	
	function get_detail($id_siswa) {
		//get nama siswa
		$this->db->select("nama");
		$this->db->from("ref_siswa");
		$this->db->where("id_siswa",$id_siswa);
		$return = $this->db->get()->row()->nama.'<br>';
		
		/* //get trans siswa
		$this->db->select("jenis_pembayaran,besarnya");
		$this->db->from("trans_siswa");
		$this->db->where("id_siswa",$id_siswa);
		$t_sis = $this->db->get()->result_array();
		
		foreach ($t_sis as $v_sis) {
			$return .= '--'.$v_sis['jenis_pembayaran'].' - '.$v_sis['besarnya'].'<br>';		
		}

		//get pem spp 	
		$this->db->select("bulan,besarnya");
		$this->db->from("trans_spp");
		$this->db->where("id_siswa",$id_siswa);
		$t_spp = $this->db->get()->result_array();
		
		foreach ($t_spp as $v_spp) {
			$return .= '-- SPP Bulan '.$v_spp['bulan'].' - '.$v_spp['besarnya'].'<br>';		
		} */
		
		return $return;
			
	}
	
	function get_detail_ppdb($id_siswa) {
		//get nama siswa
		$this->db->select("nama");
		$this->db->from("ppdb_siswa");
		$this->db->where("id_daftar",$id_siswa);
		$return = $this->db->get()->row()->nama.'<br>';
		return $return;
			
	}
	
	function get_asal_sekolah($id_siswa) {
		//get nama siswa
		$this->db->select("asal_sekolah");
		$this->db->from("ppdb_siswa");
		$this->db->where("id_daftar",$id_siswa);
		$return = $this->db->get()->row()->asal_sekolah.'<br>';
		return $return;
			
	}
	
	function getDataSMK(){
		$this->db->select('*');
		$this->db->from("ref_smk");
		$num = $this->db->get()->result_array();
		return $num;
	}
	
	function getSMK($id){
		$this->db->select('name');
		$this->db->from("ref_smk");
		$this->db->where("id",$id);
		$return = $this->db->get()->row();
		return $return;
	}
	
	function get_kelas($id_siswa) {
		 $q = $this->db->query("select kelas from ref_siswa where id_siswa=".$id_siswa);
		//echo $this->db->last_query(); die(); 					
		return $q->row()->kelas;					
	}
	function get_mapping_kelas($id_siswa) {
		$q0 = $this->db->query("select id_mapping_kelas from ref_siswa where id_siswa=".$id_siswa);
		//echo $this->db->last_query(); die(); 	
		$map_kelas = $q0->row()->id_mapping_kelas;	
		$q = $this->db->query("select * from ref_mapping_kelas where id=".$map_kelas);		
		return $q->row();					
	}
	function get_kelas_ppdb($id_siswa) {
		 $q = $this->db->query("select kelas from ppdb_siswa where id_daftar=".$id_siswa);
		//echo $this->db->last_query(); die(); 					
		return $q->row()->kelas;					
	}
	
	function ConverToRoman($num){ 
    $n = intval($num); 
    $res = ''; 

    //array of roman numbers
    $romanNumber_Array = array( 
        'M'  => 1000, 
        'CM' => 900, 
        'D'  => 500, 
        'CD' => 400, 
        'C'  => 100, 
        'XC' => 90, 
        'L'  => 50, 
        'XL' => 40, 
        'X'  => 10, 
        'IX' => 9, 
        'V'  => 5, 
        'IV' => 4, 
        'I'  => 1); 

    foreach ($romanNumber_Array as $roman => $number){ 
        //divide to get  matches
        $matches = intval($n / $number); 

        //assign the roman char * $matches
        $res .= str_repeat($roman, $matches); 

        //substract from the number
        $n = $n % $number; 
    } 

    // return the result
    return $res; 
} 

	
	function get_ruang_kelas($id_siswa) {
		/*
		$this->db->select("id_wali_kelas");
		$this->db->from("ref_siswa");
		$this->db->where("id_siswa",$id_siswa);
		$id_wali = $this->db->get()->row()->id_wali_kelas;
		
		$this->db->select("ruang_kelas");
		$this->db->from("ref_mapping_kelas");
		$this->db->where("id_karyawan",$id_wali);		
		$ruang = $this->db->get()->row()->ruang_kelas;
		*/
		
		//echo $ruang; die();
		//echo $this->db->last_query(); die();
		//return $ruang;
		
		 $q = $this->db->query("select b.name ruang_kelas from ref_siswa a, ref_smk b where a.id_smk=b.id and a.id_siswa=".$id_siswa);
		//echo $this->db->last_query(); die(); 					
		return $q->row()->ruang_kelas;					
	}
	
	function get_ruang_kelas_ppdb($id_siswa) {
		 $q = $this->db->query("select b.name ruang_kelas from ppdb_siswa a, ref_smk b where a.id_smk=b.id and a.id_daftar=".$id_siswa);				
		return $q->row()->ruang_kelas;					
	}
	
	
	function total_spp_harian($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and b.id_smk=".$smk." and SUBSTRING(a.no_faktur, 1, 2)='FM'");
		}
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
		
	}
	
	function total_spp_harian_ppdb($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_spp a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and b.id_smk=".$smk." and SUBSTRING(a.no_faktur, 1, 2)='FM'");
		}
		
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
	}
	function total_tabsis_harian($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and b.id_smk=".$smk." and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=0 and b.id_smk=".$smk." and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}
		
		
		$temp1=0;
		$temp2=0;
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			$temp1 = 0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(($q1->row()->total==0)||($q1->row()->total==NULL)){
			$temp2 = 0;
		}else{
			$temp2 = $q1->row()->total; 
		}
		
		return $temp1-$temp2;
	}
	
	function total_tabsis_harian_ppdb($periode, $smk) {
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and b.id_smk=".$smk." and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_tabsis a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.tanggal_transaksi = '".$periode."' and a.sts_ppdb=1 and b.id_smk=".$smk." and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}
		
		$temp1=0;
		$temp2=0;
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			$temp1 = 0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(($q1->row()->total==0)||($q1->row()->total==NULL)){
			$temp2 = 0;
		}else{
			$temp2 = $q1->row()->total; 
		}
		
		return $temp1-$temp2;
	}
	
	function total_cicilan_harian($periode, $smk) {
		
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.cicilan=1 and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa  and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.cicilan=1 and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=0 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}
		$temp1=0;
		$temp2=0;
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			$temp1 = 0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(($q1->row()->total==0)||($q1->row()->total==NULL)){
			$temp2 = 0;
		}else{
			$temp2 = $q1->row()->total; 
		}
		
		return $temp1-$temp2;
	}
	
	function total_cicilan_harian_ppdb($periode, $smk) {
		
		if((empty($smk))||($smk=='')){
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.cicilan=1  and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar   and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}else{
			$q = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.cicilan=1 and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FM'");
			$q1 = $this->db->query("select sum(a.besarnya) total from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar  and a.tanggal_pembayaran = '".$periode."' and a.cicilan=1 and b.id_smk=".$smk."  and a.sts_ppdb=1 and SUBSTRING(a.no_faktur, 1, 2)='FK'");
		}
		$temp1=0;
		$temp2=0;
		if(($q->row()->total==0)||($q->row()->total==NULL)){
			$temp1 = 0;
		}else{
			$temp1 = $q->row()->total; 
		}
		
		if(($q1->row()->total==0)||($q1->row()->total==NULL)){
			$temp2 = 0;
		}else{
			$temp2 = $q1->row()->total; 
		}
		
		return $temp1-$temp2;
	}
	
	
	
	
	function get_total_spp($id_siswa, $periode, $no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, SUBSTRING(no_faktur, 1, 2) as nf from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=0 and no_faktur='".$no_faktur."'");
		return $q->row()->total; 
		
	}
	function get_spp_bln($id_siswa, $periode, $no_faktur) {
$q = $this->db->query("select SUBSTRING(bulan,1,3) as bulan, tahun_ajaran, SUBSTRING(no_faktur, 1, 2) as nf  from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=0 and no_faktur='".$no_faktur."'");
		$temp=$q->result_array();
		$temp_c=count($temp);
		$text='';
		$i=1;
		foreach ($temp as $temps) {
			if($i==$temp_c){
				$text.=$temps['bulan']." (".$temps['tahun_ajaran'].") ";
			}else{
				$text.=$temps['bulan']." (".$temps['tahun_ajaran'].") ".' - ';
			}
			$i++;
		}
		return $text;		
	}
	
	function get_total_spp_ppdb($id_siswa, $periode,$no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, SUBSTRING(no_faktur, 1, 2) as nf from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=1  and no_faktur='".$no_faktur."'");
		if(($q->row()->total)==NULL){
			return 0; 
		}else{
			return $q->row()->total; 
		}
	}
	
	function get_spp_ppdb_bln($id_siswa, $periode,$no_faktur) {
$q = $this->db->query("select SUBSTRING(bulan,1,3) as bulan, tahun_ajaran, SUBSTRING(no_faktur, 1, 2) as nf from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=1  and no_faktur='".$no_faktur."'");
		$temp=$q->result_array();
		$temp_c=count($temp);
		$text='';
		$i=1;
		foreach ($temp as $temps) {
			if($i==$temp_c){
				$text.=$temps['bulan']." (".$temps['tahun_ajaran'].") ";
			}else{
				$text.=$temps['bulan']." (".$temps['tahun_ajaran'].") ".' - ';
			}
			$i++;
		}
		return $text;		
	}
	function get_teller($no_faktur) {
		$q = $this->db->query("SELECT DISTINCT(created_by) FROM `trans_siswa` WHERE no_faktur='".$no_faktur."' ");
		if(empty($q->row())){
			
			$q = $this->db->query("SELECT DISTINCT(created_by) FROM `trans_spp` WHERE no_faktur='".$no_faktur."'");
		}
		
		return $q->row()->created_by; 
		
	}
	function get_no_faktur($id_siswa, $periode) {
			$q = $this->db->query("
				select DISTINCT a.no_faktur from ( 
					SELECT no_faktur from trans_siswa where tanggal_pembayaran = '".$periode."' and id_siswa=".$id_siswa." and sts_ppdb=0
					UNION ALL 
					SELECT no_faktur from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa=".$id_siswa." and sts_ppdb=0
				) a");
		$temp=$q->result_array();
		$temp_c=count($temp);
		$text='';
		$i=1;
		foreach ($temp as $temps) {
			if($i==$temp_c){
				$text.=$temps['no_faktur'];
			}else{
				$text.=$temps['no_faktur'].' - ';
			}
			$i++;
		}
		return $text;		
	}
	
	function get_no_faktur_ppdb($id_siswa, $periode) {
		
		
			$q = $this->db->query("
				select DISTINCT a.no_faktur from ( 
					SELECT no_faktur from trans_siswa where tanggal_pembayaran = '".$periode."' and id_siswa=".$id_siswa." and sts_ppdb=1
					UNION ALL 
					SELECT no_faktur from trans_spp where tanggal_transaksi = '".$periode."' and id_siswa=".$id_siswa." and sts_ppdb=1
				) a");
		$temp=$q->result_array();
		$temp_c=count($temp);
		$text='';
		$i=1;
		foreach ($temp as $temps) {
			if($i==$temp_c){
				$text.=$temps['no_faktur'];
			}else{
				$text.=$temps['no_faktur'].' - ';
			}
			$i++;
		}
		return $text;		
	}
	function get_total_tabsis($id_siswa, $periode, $no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, SUBSTRING(no_faktur, 1, 2) as nf from trans_tabsis where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=0 and no_faktur='".$no_faktur."'");
		return $q->row(); 
		
	}
	function get_total_tabsis_ppdb($id_siswa, $periode, $no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, SUBSTRING(no_faktur, 1, 2) as nf from trans_tabsis where tanggal_transaksi = '".$periode."' and id_siswa = ".$id_siswa." and sts_ppdb=1  and no_faktur='".$no_faktur."'");
		//if(($q->row()->total)==NULL){
			//return 0; 
		//}else{
			return $q->row(); 
		//}
		
		
	}
	
	function get_total_cicilan($id_siswa,$periode, $no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, SUBSTRING(no_faktur, 1, 2) as nf from trans_siswa where id_siswa = ".$id_siswa." and cicilan=1 and sts_ppdb=0 and tanggal_pembayaran = '".$periode."' and no_faktur='".$no_faktur."'");
		
		//if(empty($q->row()->total)||($q->row()->total==NULL)){
		//	return 0;
		//}else{
			return $q->row(); 
		//}
		
	}
	
	function get_total_cicilan_ppdb($id_siswa, $periode, $no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, SUBSTRING(no_faktur, 1, 2) as nf from trans_siswa where id_siswa = ".$id_siswa." and cicilan=1 and sts_ppdb=1 and tanggal_pembayaran = '".$periode."' and no_faktur='".$no_faktur."'");
		
		//if(empty($q->row()->total)||($q->row()->total==NULL)){
			//return 0;
		//}else{
			return $q->row(); 
		//}
		
	}
	
	function get_total_bayar_cicilan($id_siswa, $kodedesk, $kodesub) {
		
		$q = $this->db->query("SELECT a.besarnya as total FROM ref_mapping_cicilan_siswa a, ref_komponen_cicilan b, ref_list_uang_masuk c  WHERE a.id_coa=b.id and b.id_coa=c.Id and a.status=1 and a.id_siswa=".$id_siswa." and c.kodedesk='".$kodedesk."' and c.kodesub='".$kodesub."'");
		if(empty($q->row()->total)||($q->row()->total==NULL)){
			return 0;
		}else{
			return $q->row()->total; 
		}
		//$data = $q->result_array();
		
	}
	
	
	function get_total_trans_harian($kodedesk, $kodesub, $periode, $smk) {
		if($smk==''){
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.kodedesk = '".$kodedesk."' and a.kodesub = '".$kodesub."' and a.tanggal_pembayaran = '".$periode."' and a.sts_ppdb=0" );
		}else{
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ref_siswa b where a.id_siswa=b.id_siswa and a.kodedesk = '".$kodedesk."' and a.kodesub = '".$kodesub."' and a.tanggal_pembayaran = '".$periode."' and b.id_smk=".$smk." and a.sts_ppdb=0" );
			
			
		}
		return $q->row();
	}
	
	function get_total_trans_harian_ppdb($kodedesk, $kodesub,$periode, $smk) {
		if($smk==''){
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.kodedesk = '".$kodedesk."' and a.kodesub = '".$kodesub."' and a.tanggal_pembayaran = '".$periode."' and a.sts_ppdb=1" );
		}else{
			$q = $this->db->query("select sum(a.besarnya) total, b.id_smk from trans_siswa a, ppdb_siswa b where a.id_siswa=b.id_daftar and a.kodedesk = '".$kodedesk."' and a.kodesub = '".$kodesub."' and a.tanggal_pembayaran = '".$periode."' and b.id_smk=".$smk." and a.sts_ppdb=1" );
			
			
		}
		return $q->row();
	}
	
	function get_total_trans($id_siswa, $periode, $kodedesk, $kodesub, $no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, b.id_smk from trans_siswa a, ref_siswa b where  a.tanggal_pembayaran = '".$periode."' and a.id_siswa=b.id_siswa and a.id_siswa = ".$id_siswa." and a.kodedesk = '".$kodedesk."' and a.kodesub = '".$kodesub."' and sts_ppdb=0 and no_faktur='".$no_faktur."'");
		return $q->row();
	}
	
	function get_total_trans_ppdb($id_siswa, $periode, $kodedesk, $kodesub, $no_faktur) {
		$q = $this->db->query("select sum(besarnya) total, b.id_smk from trans_siswa a, ppdb_siswa b where  a.tanggal_pembayaran = '".$periode."' and a.id_siswa=b.id_daftar and a.id_siswa = ".$id_siswa."  and a.kodedesk = '".$kodedesk."' and a.kodesub = '".$kodesub."'  and sts_ppdb=1 and no_faktur='".$no_faktur."'");
		return $q->row();
	}
	
}